/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClients;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;

public abstract class UaaHttpRequestUtils {
    public static ClientHttpRequestFactory createRequestFactory(boolean skipSslValidation) {
        ClientHttpRequestFactory clientHttpRequestFactory = skipSslValidation ? UaaHttpRequestUtils.getNoValidatingClientHttpRequestFactory() : UaaHttpRequestUtils.getClientHttpRequestFactory();
        return clientHttpRequestFactory;
    }

    public static ClientHttpRequestFactory createRequestFactory() {
        return UaaHttpRequestUtils.createRequestFactory(false);
    }

    public static ClientHttpRequestFactory getNoValidatingClientHttpRequestFactory() {
        SSLContext sslContext;
        try {
            sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        CloseableHttpClient httpClient = HttpClients.custom().useSystemProperties().setSslcontext(sslContext).setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy()).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        return requestFactory;
    }

    public static String paramsToQueryString(Map<String, String[]> parameterMap) {
        return parameterMap.entrySet().stream().flatMap(param -> Arrays.stream((Object[])param.getValue()).map(value -> (String)param.getKey() + "=" + UaaHttpRequestUtils.encodeParameter(value))).collect(Collectors.joining("&"));
    }

    private static String encodeParameter(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ClientHttpRequestFactory getClientHttpRequestFactory() {
        CloseableHttpClient httpClient = HttpClients.custom().useSystemProperties().setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy()).build();
        return new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
    }
}

