/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.account;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.account.PasswordConfirmationValidation;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidPasswordException;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

public class ResetPasswordAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        Throwable cause = authException.getCause();
        response.setStatus(HttpStatus.UNPROCESSABLE_ENTITY.value());
        HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(request){

            public String getMethod() {
                return "GET";
            }
        };
        if (cause instanceof PasswordConfirmationValidation.PasswordConfirmationException) {
            PasswordConfirmationValidation.PasswordConfirmationException passwordConfirmationException = (PasswordConfirmationValidation.PasswordConfirmationException)((Object)cause);
            request.setAttribute("email", (Object)passwordConfirmationException.getEmail());
            request.setAttribute("code", (Object)request.getParameter("code"));
            request.setAttribute("message_code", (Object)passwordConfirmationException.getMessageCode());
            request.getRequestDispatcher("/reset_password").forward((ServletRequest)wrapper, (ServletResponse)response);
            return;
        }
        if (cause instanceof InvalidPasswordException) {
            InvalidPasswordException exception = (InvalidPasswordException)cause;
            request.setAttribute("message", (Object)exception.getMessagesAsOneString());
        } else {
            request.setAttribute("message_code", (Object)"bad_code");
        }
        request.getRequestDispatcher("/forgot_password").forward((ServletRequest)wrapper, (ServletResponse)response);
    }
}

