/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import java.util.List;
import org.cloudfoundry.identity.uaa.audit.AuditEvent;
import org.cloudfoundry.identity.uaa.audit.AuditEventType;
import org.cloudfoundry.identity.uaa.audit.UaaAuditService;
import org.cloudfoundry.identity.uaa.authentication.manager.LockoutPolicyRetriever;
import org.cloudfoundry.identity.uaa.authentication.manager.LoginPolicy;
import org.cloudfoundry.identity.uaa.provider.LockoutPolicy;

public class CommonLoginPolicy
implements LoginPolicy {
    private final UaaAuditService auditService;
    private final LockoutPolicyRetriever lockoutPolicyRetriever;
    private final AuditEventType successEventType;
    private final AuditEventType failureEventType;

    public CommonLoginPolicy(UaaAuditService auditService, LockoutPolicyRetriever lockoutPolicyRetriever, AuditEventType successEventType, AuditEventType failureEventType) {
        this.auditService = auditService;
        this.lockoutPolicyRetriever = lockoutPolicyRetriever;
        this.successEventType = successEventType;
        this.failureEventType = failureEventType;
    }

    @Override
    public LoginPolicy.Result isAllowed(String principalId) {
        AuditEvent lastFailure;
        LockoutPolicy lockoutPolicy = this.lockoutPolicyRetriever.getLockoutPolicy();
        long eventsAfter = System.currentTimeMillis() - (long)(lockoutPolicy.getCountFailuresWithin() * 1000);
        List<AuditEvent> events = this.auditService.find(principalId, eventsAfter);
        int failureCount = this.sequentialFailureCount(events);
        if (failureCount >= lockoutPolicy.getLockoutAfterFailures() && (lastFailure = this.mostRecentFailure(events)) != null && lastFailure.getTime() > System.currentTimeMillis() - (long)(lockoutPolicy.getLockoutPeriodSeconds() * 1000)) {
            return new LoginPolicy.Result(false, failureCount);
        }
        return new LoginPolicy.Result(true, failureCount);
    }

    private int sequentialFailureCount(List<AuditEvent> events) {
        int failureCount = 0;
        for (AuditEvent event : events) {
            if (event.getType() == this.failureEventType) {
                ++failureCount;
                continue;
            }
            if (event.getType() != this.successEventType) continue;
            break;
        }
        return failureCount;
    }

    private AuditEvent mostRecentFailure(List<AuditEvent> events) {
        for (AuditEvent event : events) {
            if (event.getType() != this.failureEventType) continue;
            return event;
        }
        return null;
    }

    @Override
    public LockoutPolicyRetriever getLockoutPolicyRetriever() {
        return this.lockoutPolicyRetriever;
    }
}

