/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpParams;
import org.opensaml.saml2.metadata.provider.HTTPMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.springframework.web.client.RestTemplate;

public class FixedHttpMetaDataProvider
extends HTTPMetadataProvider {
    private static final byte[] CLASS_DEF = new byte[0];
    private static AtomicLong expirationTimeMillis = new AtomicLong(600000L);
    private static Ticker ticker = new Ticker(){

        public long read() {
            return System.nanoTime();
        }
    };
    private RestTemplate template;
    protected static volatile Cache<String, CacheEntry> metadataCache = FixedHttpMetaDataProvider.buildCache();

    protected static Cache<String, CacheEntry> buildCache() {
        return CacheBuilder.newBuilder().expireAfterWrite(expirationTimeMillis.get(), TimeUnit.MILLISECONDS).maximumSize(20000L).ticker(ticker).build();
    }

    public static FixedHttpMetaDataProvider buildProvider(Timer backgroundTaskTimer, HttpClientParams params, String metadataURL, RestTemplate template) throws MetadataProviderException {
        SimpleHttpConnectionManager connectionManager = new SimpleHttpConnectionManager(true);
        connectionManager.getParams().setDefaults((HttpParams)params);
        HttpClient client = new HttpClient((HttpConnectionManager)connectionManager);
        return new FixedHttpMetaDataProvider(backgroundTaskTimer, client, metadataURL, template);
    }

    private FixedHttpMetaDataProvider(Timer backgroundTaskTimer, HttpClient client, String metadataURL, RestTemplate template) throws MetadataProviderException {
        super(backgroundTaskTimer, client, metadataURL);
        this.template = template;
    }

    public byte[] fetchMetadata() throws MetadataProviderException {
        byte[] metadata;
        CacheEntry entry = (CacheEntry)metadataCache.getIfPresent((Object)this.getMetadataURI());
        byte[] byArray = metadata = entry != null ? entry.getData() : null;
        if (metadata == null || System.currentTimeMillis() - entry.getTimeEntered() > FixedHttpMetaDataProvider.getExpirationTimeMillis()) {
            metadata = (byte[])this.template.getForObject(this.getMetadataURI(), CLASS_DEF.getClass(), new Object[0]);
            metadataCache.put((Object)this.getMetadataURI(), (Object)new CacheEntry(System.currentTimeMillis(), metadata));
        }
        return metadata;
    }

    public static long getExpirationTimeMillis() {
        return expirationTimeMillis.get();
    }

    public static void setExpirationTimeMillis(long expirationTimeMillis) {
        if (FixedHttpMetaDataProvider.expirationTimeMillis.getAndSet(expirationTimeMillis) != expirationTimeMillis) {
            metadataCache = FixedHttpMetaDataProvider.buildCache();
        }
    }

    public static void setTicker(Ticker ticker) {
        if (ticker != FixedHttpMetaDataProvider.ticker) {
            FixedHttpMetaDataProvider.ticker = ticker;
            metadataCache = FixedHttpMetaDataProvider.buildCache();
        }
    }

    static class CacheEntry {
        private final long timeEntered;
        private final byte[] data;

        public CacheEntry(long timeEntered, byte[] data) {
            this.timeEntered = timeEntered;
            this.data = data;
        }

        public long getTimeEntered() {
            return this.timeEntered;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

