/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.impl.config;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.log4j.MDC;
import org.cloudfoundry.identity.uaa.impl.config.NestedMapPropertySource;
import org.cloudfoundry.identity.uaa.impl.config.SystemEnvironmentAccessor;
import org.cloudfoundry.identity.uaa.impl.config.YamlMapFactoryBean;
import org.cloudfoundry.identity.uaa.impl.config.YamlProcessor;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.util.InMemoryResource;
import org.springframework.util.Log4jConfigurer;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.yaml.snakeyaml.Yaml;

public class YamlServletProfileInitializer
implements ApplicationContextInitializer<ConfigurableWebApplicationContext> {
    private static final String PROFILE_CONFIG_FILE_LOCATIONS = "environmentConfigLocations";
    private static final String PROFILE_CONFIG_FILE_DEFAULT = "environmentConfigDefaults";
    public static final String[] DEFAULT_PROFILE_CONFIG_FILE_LOCATIONS = new String[]{"${APPLICATION_CONFIG_URL}", "file:${APPLICATION_CONFIG_FILE}"};
    private static final String DEFAULT_YAML_KEY = "environmentYamlKey";
    private String rawYamlKey = "environmentYamlKey";
    private String yamlEnvironmentVariableName = "UAA_CONFIG_YAML";
    private SystemEnvironmentAccessor environmentAccessor = new SystemEnvironmentAccessor(){};

    public void initialize(ConfigurableWebApplicationContext applicationContext) {
        ServletContext servletContext = applicationContext.getServletContext();
        WebApplicationContextUtils.initServletPropertySources((MutablePropertySources)applicationContext.getEnvironment().getPropertySources(), (ServletContext)servletContext, (ServletConfig)applicationContext.getServletConfig());
        ServletConfig servletConfig = applicationContext.getServletConfig();
        String locations = servletConfig == null ? null : servletConfig.getInitParameter(PROFILE_CONFIG_FILE_LOCATIONS);
        ArrayList<Object> resources = new ArrayList<Object>();
        Set defaultLocation = StringUtils.commaDelimitedListToSet(servletConfig == null ? null : servletConfig.getInitParameter(PROFILE_CONFIG_FILE_DEFAULT));
        if (defaultLocation != null && defaultLocation.size() > 0) {
            for (String s : defaultLocation) {
                ClassPathResource defaultResource = new ClassPathResource(s);
                if (!defaultResource.exists()) continue;
                resources.add(defaultResource);
            }
        }
        resources.addAll(this.getResource(servletContext, applicationContext, locations));
        Resource yamlFromEnv = this.getYamlFromEnvironmentVariable();
        if (yamlFromEnv != null) {
            resources.add(yamlFromEnv);
        }
        if (resources.isEmpty()) {
            servletContext.log("No YAML environment properties from servlet.  Defaulting to servlet context.");
            locations = servletContext.getInitParameter(PROFILE_CONFIG_FILE_LOCATIONS);
            resources.addAll(this.getResource(servletContext, applicationContext, locations));
        }
        try {
            servletContext.log("Loading YAML environment properties from location: " + ((Object)resources).toString());
            YamlMapFactoryBean factory = new YamlMapFactoryBean();
            factory.setResolutionMethod(YamlProcessor.ResolutionMethod.OVERRIDE_AND_IGNORE);
            factory.setResources(resources.toArray(new Resource[resources.size()]));
            Object map = factory.getObject();
            String yamlStr = new Yaml().dump(map);
            map.put(this.rawYamlKey, yamlStr);
            NestedMapPropertySource properties = new NestedMapPropertySource("servletConfigYaml", (Map<String, ?>)map);
            applicationContext.getEnvironment().getPropertySources().addLast((PropertySource)properties);
            this.applySpringProfiles(applicationContext.getEnvironment(), servletContext);
            this.applyLog4jConfiguration(applicationContext.getEnvironment(), servletContext);
        }
        catch (Exception e) {
            servletContext.log("Error loading YAML environment properties from location: " + ((Object)resources).toString(), (Throwable)e);
        }
    }

    protected Resource getYamlFromEnvironmentVariable() {
        String data;
        if (this.getEnvironmentAccessor() != null && StringUtils.hasText((String)(data = this.getEnvironmentAccessor().getEnvironmentVariable(this.getYamlEnvironmentVariableName())))) {
            return new InMemoryResource(data);
        }
        return null;
    }

    private List<Resource> getResource(ServletContext servletContext, ConfigurableWebApplicationContext applicationContext, String locations) {
        String[] configFileLocations;
        LinkedList<Resource> resources = new LinkedList<Resource>();
        for (String location : configFileLocations = locations == null ? DEFAULT_PROFILE_CONFIG_FILE_LOCATIONS : StringUtils.commaDelimitedListToStringArray((String)locations)) {
            location = applicationContext.getEnvironment().resolvePlaceholders(location);
            servletContext.log("Testing for YAML resources at: " + location);
            Resource resource = applicationContext.getResource(location);
            if (resource == null || !resource.exists()) continue;
            resources.add(resource);
        }
        return resources;
    }

    private void applyLog4jConfiguration(ConfigurableEnvironment environment, ServletContext servletContext) {
        String location;
        String log4jConfigLocation = "classpath:log4j.properties";
        if (environment.containsProperty("logging.file")) {
            location = environment.getProperty("logging.file");
            servletContext.log("Setting LOG_FILE: " + location);
            System.setProperty("LOG_FILE", location);
        } else if (environment.containsProperty("logging.path")) {
            location = environment.getProperty("logging.path");
            servletContext.log("Setting LOG_PATH: " + location);
            System.setProperty("LOG_PATH", location);
        } else if (environment.containsProperty("logging.config") && (location = environment.getProperty("logging.config")) != null && location.trim().length() > 0) {
            PropertySource environmentPropertySource = environment.getPropertySources().get("systemEnvironment");
            if (location.startsWith("-D") && environmentPropertySource != null && location.equals(environmentPropertySource.getProperty("LOGGING_CONFIG"))) {
                servletContext.log("Ignoring Log Config Location: " + location + ". Location is suspect to be a Tomcat startup script environment variable");
            } else {
                servletContext.log("Setting Log Config Location: " + location + " based on logging.config setting.");
                log4jConfigLocation = environment.getProperty("logging.config");
            }
        }
        try {
            servletContext.log("Loading log4j config from location: " + log4jConfigLocation);
            Log4jConfigurer.initLogging((String)log4jConfigLocation);
        }
        catch (FileNotFoundException e) {
            servletContext.log("Error loading log4j config from location: " + log4jConfigLocation, (Throwable)e);
        }
        MDC.put((String)"context", (Object)servletContext.getContextPath());
    }

    private void applySpringProfiles(ConfigurableEnvironment environment, ServletContext servletContext) {
        if (environment.containsProperty("spring_profiles")) {
            String profiles = environment.getProperty("spring_profiles");
            servletContext.log("Setting active profiles: " + profiles);
            environment.setActiveProfiles(StringUtils.tokenizeToStringArray((String)profiles, (String)",", (boolean)true, (boolean)true));
        }
    }

    public String getYamlEnvironmentVariableName() {
        return this.yamlEnvironmentVariableName;
    }

    public void setYamlEnvironmentVariableName(String yamlEnvironmentVariableName) {
        this.yamlEnvironmentVariableName = yamlEnvironmentVariableName;
    }

    public SystemEnvironmentAccessor getEnvironmentAccessor() {
        return this.environmentAccessor;
    }

    public void setEnvironmentAccessor(SystemEnvironmentAccessor environmentAccessor) {
        this.environmentAccessor = environmentAccessor;
    }
}

