/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.login;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;

public class CurrentUserCookieDestructor
implements AuthenticationFailureHandler,
LogoutHandler {
    private AuthenticationFailureHandler delegate;

    public CurrentUserCookieDestructor(AuthenticationFailureHandler delegate) {
        this.delegate = delegate;
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        this.addCookie(response, request.getContextPath());
        if (this.delegate != null) {
            this.delegate.onAuthenticationFailure(request, response, exception);
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        this.addCookie(response, request.getContextPath());
    }

    private void addCookie(HttpServletResponse response, String contextPath) {
        Cookie currentUserCookie = new Cookie("Current-User", null);
        currentUserCookie.setHttpOnly(false);
        currentUserCookie.setMaxAge(0);
        currentUserCookie.setPath(contextPath);
        response.addCookie(currentUserCookie);
    }
}

