/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.account;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import org.cloudfoundry.identity.uaa.account.AccountCreationService;
import org.cloudfoundry.identity.uaa.account.PasswordConfirmationValidation;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.error.UaaException;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidPasswordException;
import org.cloudfoundry.identity.uaa.user.UaaAuthority;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.hibernate.validator.constraints.Email;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.client.HttpClientErrorException;

@Controller
public class AccountsController {
    private final AccountCreationService accountCreationService;

    public AccountsController(AccountCreationService accountCreationService) {
        this.accountCreationService = accountCreationService;
    }

    @RequestMapping(value={"/create_account"}, method={RequestMethod.GET})
    public String activationEmail(Model model, @RequestParam(value="client_id", required=false) String clientId, @RequestParam(value="redirect_uri", required=false) String redirectUri, HttpServletResponse response) {
        if (!IdentityZoneHolder.get().getConfig().getLinks().getSelfService().isSelfServiceLinksEnabled()) {
            return this.handleSelfServiceDisabled(model, response, "error_message_code", "self_service_disabled");
        }
        model.addAttribute("client_id", (Object)clientId);
        model.addAttribute("redirect_uri", (Object)redirectUri);
        return "accounts/new_activation_email";
    }

    @RequestMapping(value={"/create_account.do"}, method={RequestMethod.POST})
    public String sendActivationEmail(Model model, HttpServletResponse response, @RequestParam(value="client_id", required=false) String clientId, @RequestParam(value="redirect_uri", required=false) String redirectUri, @Valid @ModelAttribute(value="email") ValidEmail email, BindingResult result, @RequestParam(value="password") String password, @RequestParam(value="password_confirmation") String passwordConfirmation) {
        if (!IdentityZoneHolder.get().getConfig().getLinks().getSelfService().isSelfServiceLinksEnabled()) {
            return this.handleSelfServiceDisabled(model, response, "error_message_code", "self_service_disabled");
        }
        if (result.hasErrors()) {
            return this.handleUnprocessableEntity(model, response, "error_message_code", "invalid_email");
        }
        PasswordConfirmationValidation validation = new PasswordConfirmationValidation(password, passwordConfirmation);
        if (!validation.valid()) {
            return this.handleUnprocessableEntity(model, response, "error_message_code", validation.getMessageCode());
        }
        try {
            this.accountCreationService.beginActivation(email.getEmail(), password, clientId, redirectUri);
        }
        catch (UaaException e) {
            return this.handleUnprocessableEntity(model, response, "error_message_code", "username_exists");
        }
        catch (InvalidPasswordException e) {
            return this.handleUnprocessableEntity(model, response, "error_message", e.getMessagesAsOneString());
        }
        return "redirect:accounts/email_sent";
    }

    @RequestMapping(value={"/accounts/email_sent"}, method={RequestMethod.GET})
    public String emailSent() {
        return "accounts/email_sent";
    }

    @RequestMapping(value={"/verify_user"}, method={RequestMethod.GET})
    public String verifyUser(Model model, @RequestParam(value="code") String code, HttpServletResponse response, HttpSession session) throws IOException {
        AccountCreationService.AccountCreationResponse accountCreation;
        try {
            accountCreation = this.accountCreationService.completeActivation(code);
        }
        catch (HttpClientErrorException e) {
            model.addAttribute("error_message_code", (Object)"code_expired");
            response.setStatus(HttpStatus.UNPROCESSABLE_ENTITY.value());
            return "accounts/link_prompt";
        }
        UaaPrincipal uaaPrincipal = new UaaPrincipal(accountCreation.getUserId(), accountCreation.getUsername(), accountCreation.getEmail(), "uaa", null, IdentityZoneHolder.get().getId());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)uaaPrincipal, null, UaaAuthority.USER_AUTHORITIES);
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        String redirectLocation = accountCreation.getRedirectLocation();
        SavedRequest savedRequest = (SavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST");
        if (redirectLocation.equals(this.accountCreationService.getDefaultRedirect()) && savedRequest != null && savedRequest.getRedirectUrl() != null) {
            redirectLocation = savedRequest.getRedirectUrl();
        }
        return "redirect:" + redirectLocation;
    }

    private String handleUnprocessableEntity(Model model, HttpServletResponse response, String attributeKey, String attributeValue) {
        model.addAttribute(attributeKey, (Object)attributeValue);
        response.setStatus(HttpStatus.UNPROCESSABLE_ENTITY.value());
        return "accounts/new_activation_email";
    }

    private String handleSelfServiceDisabled(Model model, HttpServletResponse response, String attributeKey, String attributeValue) {
        model.addAttribute(attributeKey, (Object)attributeValue);
        response.setStatus(HttpStatus.NOT_FOUND.value());
        return "error";
    }

    public static class ValidEmail {
        @Email
        String email;

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }
    }
}

