/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.listener;

import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.event.UserAuthenticationSuccessEvent;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.springframework.context.ApplicationListener;

public class UserAuthenticationSuccessListener
implements ApplicationListener<UserAuthenticationSuccessEvent> {
    private final ScimUserProvisioning scimUserProvisioning;

    public UserAuthenticationSuccessListener(ScimUserProvisioning scimUserProvisioning) {
        this.scimUserProvisioning = scimUserProvisioning;
    }

    public void onApplicationEvent(UserAuthenticationSuccessEvent event) {
        UaaUser user = event.getUser();
        if (user.isLegacyVerificationBehavior() && !user.isVerified()) {
            this.scimUserProvisioning.verifyUser(user.getId(), -1);
        }
        UaaAuthentication authentication = (UaaAuthentication)event.getAuthentication();
        authentication.setLastLoginSuccessTime(user.getLastLogonTime());
        this.scimUserProvisioning.updateLastLogonTime(user.getId());
    }
}

