/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.AccountNotPreCreatedException;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.authentication.event.UserAuthenticationSuccessEvent;
import org.cloudfoundry.identity.uaa.authentication.manager.NewUserAuthenticatedEvent;
import org.cloudfoundry.identity.uaa.provider.ExternalIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.user.DialableByPhone;
import org.cloudfoundry.identity.uaa.user.ExternallyIdentifiable;
import org.cloudfoundry.identity.uaa.user.Mailable;
import org.cloudfoundry.identity.uaa.user.Named;
import org.cloudfoundry.identity.uaa.user.UaaAuthority;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.user.UaaUserPrototype;
import org.cloudfoundry.identity.uaa.user.UserInfo;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class ExternalLoginAuthenticationManager<ExternalAuthenticationDetails>
implements AuthenticationManager,
ApplicationEventPublisherAware,
BeanNameAware {
    public static final String USER_ATTRIBUTE_PREFIX = "user.attribute.";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ApplicationEventPublisher eventPublisher;
    private UaaUserDatabase userDatabase;
    private String name;
    private String origin = "unknown";
    private IdentityProviderProvisioning providerProvisioning;

    public ExternalLoginAuthenticationManager(IdentityProviderProvisioning providerProvisioning) {
        this.providerProvisioning = providerProvisioning;
    }

    public IdentityProviderProvisioning getProviderProvisioning() {
        return this.providerProvisioning;
    }

    public void setProviderProvisioning(IdentityProviderProvisioning providerProvisioning) {
        this.providerProvisioning = providerProvisioning;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setUserDatabase(UaaUserDatabase userDatabase) {
        this.userDatabase = userDatabase;
    }

    public UaaUserDatabase getUserDatabase() {
        return this.userDatabase;
    }

    public Authentication authenticate(Authentication request) throws AuthenticationException {
        UaaUser userFromDb;
        this.logger.debug((Object)("Starting external authentication for:" + request));
        ExternalAuthenticationDetails authenticationData = this.getExternalAuthenticationDetails(request);
        UaaUser userFromRequest = this.getUser(request, authenticationData);
        if (userFromRequest == null) {
            return null;
        }
        try {
            this.logger.debug((Object)String.format("Searching for user by (username:%s , origin:%s)", userFromRequest.getUsername(), this.getOrigin()));
            userFromDb = this.userDatabase.retrieveUserByName(userFromRequest.getUsername(), this.getOrigin());
        }
        catch (UsernameNotFoundException e) {
            this.logger.debug((Object)String.format("Searching for user by (email:%s , origin:%s)", userFromRequest.getEmail(), this.getOrigin()));
            userFromDb = this.userDatabase.retrieveUserByEmail(userFromRequest.getEmail(), this.getOrigin());
        }
        if (userFromDb == null) {
            if (!this.isAddNewShadowUser()) {
                throw new AccountNotPreCreatedException("The user account must be pre-created. Please contact your system administrator.");
            }
            this.publish(new NewUserAuthenticatedEvent(userFromRequest));
            try {
                userFromDb = this.userDatabase.retrieveUserByName(userFromRequest.getUsername(), this.getOrigin());
            }
            catch (UsernameNotFoundException ex) {
                throw new BadCredentialsException("Unable to register user in internal UAA store.");
            }
        }
        UaaUser user = this.userAuthenticated(request, userFromRequest, userFromDb);
        UaaAuthenticationDetails uaaAuthenticationDetails = request.getDetails() instanceof UaaAuthenticationDetails ? (UaaAuthenticationDetails)request.getDetails() : UaaAuthenticationDetails.UNKNOWN;
        UaaAuthentication success = new UaaAuthentication(new UaaPrincipal(user), user.getAuthorities(), uaaAuthenticationDetails);
        this.populateAuthenticationAttributes(success, request, authenticationData);
        this.publish(new UserAuthenticationSuccessEvent(user, (Authentication)success));
        return success;
    }

    protected void populateAuthenticationAttributes(UaaAuthentication authentication, Authentication request, ExternalAuthenticationDetails authenticationData) {
        IdentityProvider provider;
        if (request.getPrincipal() instanceof UserDetails) {
            UserDetails userDetails = (UserDetails)request.getPrincipal();
            authentication.setUserAttributes(this.getUserAttributes(userDetails));
            authentication.setExternalGroups(new HashSet<String>(this.getExternalUserAuthorities(userDetails)));
        }
        if (authentication.getAuthenticationMethods() == null) {
            authentication.setAuthenticationMethods(new HashSet<String>());
        }
        authentication.getAuthenticationMethods().add("ext");
        if (authentication.getUserAttributes() != null && authentication.getUserAttributes().size() > 0 && this.getProviderProvisioning() != null && (provider = this.getProviderProvisioning().retrieveByOrigin(this.getOrigin(), IdentityZoneHolder.get().getId())).getConfig() != null && ((ExternalIdentityProviderDefinition)provider.getConfig()).isStoreCustomAttributes()) {
            this.logger.debug((Object)("Storing custom attributes for user_id:" + authentication.getPrincipal().getId()));
            UserInfo userInfo = new UserInfo().setUserAttributes(authentication.getUserAttributes()).setRoles(new LinkedList<String>((Collection)Optional.ofNullable(authentication.getExternalGroups()).orElse(Collections.EMPTY_SET)));
            this.getUserDatabase().storeUserInfo(authentication.getPrincipal().getId(), userInfo);
        }
    }

    protected ExternalAuthenticationDetails getExternalAuthenticationDetails(Authentication authentication) {
        return null;
    }

    protected boolean isAddNewShadowUser() {
        return true;
    }

    protected MultiValueMap<String, String> getUserAttributes(UserDetails request) {
        return new LinkedMultiValueMap();
    }

    protected List<String> getExternalUserAuthorities(UserDetails request) {
        return new LinkedList<String>();
    }

    protected void publish(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    protected UaaUser userAuthenticated(Authentication request, UaaUser userFromRequest, UaaUser userFromDb) {
        return userFromDb;
    }

    protected UaaUser getUser(Authentication request, ExternalAuthenticationDetails authDetails) {
        UserDetails userDetails;
        if (request.getPrincipal() instanceof UserDetails) {
            userDetails = (UserDetails)request.getPrincipal();
        } else if (request instanceof UsernamePasswordAuthenticationToken) {
            String username = request.getPrincipal().toString();
            String password = request.getCredentials() != null ? request.getCredentials().toString() : "";
            userDetails = new User(username, password, true, true, true, true, UaaAuthority.USER_AUTHORITIES);
        } else {
            if (request.getPrincipal() == null) {
                this.logger.debug((Object)(this.getClass().getName() + "[" + this.name + "] cannot process null principal"));
                return null;
            }
            this.logger.debug((Object)(this.getClass().getName() + "[" + this.name + "] cannot process request of type: " + request.getClass().getName()));
            return null;
        }
        String name = userDetails.getUsername();
        String email = null;
        if (userDetails instanceof Mailable) {
            email = ((Mailable)userDetails).getEmailAddress();
            if (name == null) {
                name = email;
            }
        }
        if (email == null) {
            email = this.generateEmailIfNull(name);
        }
        String givenName = null;
        String familyName = null;
        if (userDetails instanceof Named) {
            Named names = (Named)userDetails;
            givenName = names.getGivenName();
            familyName = names.getFamilyName();
        }
        String phoneNumber = userDetails instanceof DialableByPhone ? ((DialableByPhone)userDetails).getPhoneNumber() : null;
        String externalId = userDetails instanceof ExternallyIdentifiable ? ((ExternallyIdentifiable)userDetails).getExternalId() : name;
        UaaUserPrototype userPrototype = new UaaUserPrototype().withUsername(name).withPassword("").withEmail(email).withAuthorities(UaaAuthority.USER_AUTHORITIES).withGivenName(givenName).withFamilyName(familyName).withCreated(new Date()).withModified(new Date()).withOrigin(this.origin).withExternalId(externalId).withZoneId(IdentityZoneHolder.get().getId()).withPhoneNumber(phoneNumber);
        return new UaaUser(userPrototype);
    }

    protected String generateEmailIfNull(String name) {
        String email;
        if (name != null) {
            email = name.contains("@") ? (name.split("@").length == 2 && !name.startsWith("@") && !name.endsWith("@") ? name : name.replaceAll("@", "") + "@user.from." + this.getOrigin() + ".cf") : name + "@user.from." + this.getOrigin() + ".cf";
        } else {
            throw new BadCredentialsException("Cannot determine username from credentials supplied");
        }
        return email;
    }

    protected boolean haveUserAttributesChanged(UaaUser existingUser, UaaUser user) {
        return !StringUtils.equals((String)existingUser.getGivenName(), (String)user.getGivenName()) || !StringUtils.equals((String)existingUser.getFamilyName(), (String)user.getFamilyName()) || !StringUtils.equals((String)existingUser.getPhoneNumber(), (String)user.getPhoneNumber()) || !StringUtils.equals((String)existingUser.getEmail(), (String)user.getEmail());
    }

    public void setBeanName(String name) {
        this.name = name;
    }
}

