/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.provider.ldap.extension.ExtendedLdapUserImpl;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.ldap.userdetails.LdapUserDetails;
import org.springframework.security.ldap.userdetails.LdapUserDetailsMapper;

public class ExtendedLdapUserMapper
extends LdapUserDetailsMapper {
    private static final Log logger = LogFactory.getLog(ExtendedLdapUserMapper.class);
    public static final String SUBSTITUTE_MAIL_ATTR_NAME = "substitute-mail-attribute";
    private String mailAttributeName = "mail";
    private String givenNameAttributeName;
    private String familyNameAttributeName;
    private String phoneNumberAttributeName;
    private String mailSubstitute = null;
    private boolean mailSubstituteOverrides = false;

    public UserDetails mapUserFromContext(DirContextOperations ctx, String username, Collection<? extends GrantedAuthority> authorities) {
        LdapUserDetails ldapUserDetails = (LdapUserDetails)super.mapUserFromContext(ctx, username, authorities);
        DirContextAdapter adapter = (DirContextAdapter)ctx;
        HashMap<String, String[]> record = new HashMap<String, String[]>();
        ArrayList<String> attributeNames = Collections.list(adapter.getAttributes().getIDs());
        for (String attributeName : attributeNames) {
            try {
                Object[] objValues = adapter.getObjectAttributes(attributeName);
                String[] values = new String[objValues != null ? objValues.length : 0];
                for (int i = 0; i < values.length; ++i) {
                    if (objValues[i] == null) continue;
                    values[i] = objValues[i].getClass().isAssignableFrom(String.class) ? (String)objValues[i] : (objValues[i] instanceof byte[] ? new String((byte[])objValues[i]) : objValues[i].toString());
                }
                if (values == null || values.length == 0) {
                    logger.debug((Object)("No attribute value found for '" + attributeName + "'"));
                    continue;
                }
                record.put(attributeName, values);
            }
            catch (ArrayStoreException x) {
                logger.debug((Object)("Attribute value is not a string for '" + attributeName + "'"));
            }
        }
        record.put("spring.security.ldap.dn", new String[]{adapter.getDn().toString()});
        String mailAttr = this.configureMailAttribute(username, record);
        ExtendedLdapUserImpl result = new ExtendedLdapUserImpl(ldapUserDetails, record);
        result.setMailAttributeName(mailAttr);
        result.setGivenNameAttributeName(this.givenNameAttributeName);
        result.setFamilyNameAttributeName(this.familyNameAttributeName);
        result.setPhoneNumberAttributeName(this.phoneNumberAttributeName);
        return result;
    }

    protected String configureMailAttribute(String username, Map<String, String[]> record) {
        String result = this.getMailAttributeName();
        if (this.getMailSubstitute() != null) {
            String subemail = this.substituteMail(username);
            record.put(SUBSTITUTE_MAIL_ATTR_NAME, new String[]{subemail});
            if (this.isMailSubstituteOverridesLdap() || record.get(this.getMailAttributeName()) == null || record.get(this.getMailAttributeName()).length == 0) {
                result = SUBSTITUTE_MAIL_ATTR_NAME;
            }
        }
        return result;
    }

    protected String substituteMail(String username) {
        if (this.getMailSubstitute() == null) {
            return null;
        }
        return this.getMailSubstitute().replace("{0}", username);
    }

    public String getMailAttributeName() {
        return this.mailAttributeName;
    }

    public void setMailAttributeName(String mailAttributeName) {
        this.mailAttributeName = mailAttributeName;
    }

    public String getPhoneNumberAttributeName() {
        return this.phoneNumberAttributeName;
    }

    public void setPhoneNumberAttributeName(String phoneNumberAttributeName) {
        this.phoneNumberAttributeName = phoneNumberAttributeName;
    }

    public String getGivenNameAttributeName() {
        return this.givenNameAttributeName;
    }

    public void setGivenNameAttributeName(String givenNameAttributeName) {
        this.givenNameAttributeName = givenNameAttributeName;
    }

    public String getFamilyNameAttributeName() {
        return this.familyNameAttributeName;
    }

    public void setFamilyNameAttributeName(String familyNameAttributeName) {
        this.familyNameAttributeName = familyNameAttributeName;
    }

    public String getMailSubstitute() {
        return this.mailSubstitute;
    }

    public void setMailSubstitute(String mailSubstitute) {
        if ("null".equals(mailSubstitute) || "".equals(mailSubstitute)) {
            mailSubstitute = null;
        }
        if (mailSubstitute != null && !mailSubstitute.contains("{0}")) {
            throw new IllegalArgumentException("Invalid mail substitute pattern, {0} is missing.");
        }
        this.mailSubstitute = mailSubstitute;
    }

    public boolean isMailSubstituteOverridesLdap() {
        return this.mailSubstituteOverrides;
    }

    public void setMailSubstituteOverridesLdap(boolean mailSubstituteOverridesLdap) {
        this.mailSubstituteOverrides = mailSubstituteOverridesLdap;
    }
}

