/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.account;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.cloudfoundry.identity.uaa.account.ChangeEmailService;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.error.UaaException;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.hibernate.validator.constraints.Email;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class ChangeEmailController {
    private final ChangeEmailService changeEmailService;
    private UaaUserDatabase uaaUserDatabase;

    public void setUaaUserDatabase(UaaUserDatabase uaaUserDatabase) {
        this.uaaUserDatabase = uaaUserDatabase;
    }

    public ChangeEmailController(ChangeEmailService changeEmailService) {
        this.changeEmailService = changeEmailService;
    }

    @RequestMapping(value={"/change_email"}, method={RequestMethod.GET})
    public String changeEmailPage(Model model, @RequestParam(value="client_id", required=false) String clientId, @RequestParam(value="redirect_uri", required=false) String redirectUri) {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        model.addAttribute("email", (Object)((UaaPrincipal)securityContext.getAuthentication().getPrincipal()).getEmail());
        model.addAttribute("client_id", (Object)clientId);
        model.addAttribute("redirect_uri", (Object)redirectUri);
        return "change_email";
    }

    @RequestMapping(value={"/change_email.do"}, method={RequestMethod.POST})
    public String changeEmail(Model model, @Valid @ModelAttribute(value="newEmail") ValidEmail newEmail, BindingResult result, @RequestParam(required=false, value="client_id") String clientId, @RequestParam(required=false, value="redirect_uri") String redirectUri, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        block4: {
            SecurityContext securityContext = SecurityContextHolder.getContext();
            if (result.hasErrors()) {
                model.addAttribute("error_message_code", (Object)"invalid_email");
                model.addAttribute("email", (Object)((UaaPrincipal)securityContext.getAuthentication().getPrincipal()).getEmail());
                response.setStatus(HttpStatus.UNPROCESSABLE_ENTITY.value());
                return "change_email";
            }
            String origin = ((UaaPrincipal)securityContext.getAuthentication().getPrincipal()).getOrigin();
            if (!origin.equals("uaa")) {
                redirectAttributes.addAttribute("error_message_code", (Object)"email_change.non-uaa-origin");
                return "redirect:profile";
            }
            String userId = ((UaaPrincipal)securityContext.getAuthentication().getPrincipal()).getId();
            String userEmail = ((UaaPrincipal)securityContext.getAuthentication().getPrincipal()).getName();
            try {
                this.changeEmailService.beginEmailChange(userId, userEmail, newEmail.getNewEmail(), clientId, redirectUri);
            }
            catch (UaaException e) {
                if (e.getHttpStatus() != 409) break block4;
                model.addAttribute("error_message_code", (Object)"username_exists");
                model.addAttribute("email", (Object)((UaaPrincipal)securityContext.getAuthentication().getPrincipal()).getEmail());
                response.setStatus(HttpStatus.UNPROCESSABLE_ENTITY.value());
                return "change_email";
            }
        }
        return "redirect:email_sent?code=email_change";
    }

    @RequestMapping(value={"/verify_email"}, method={RequestMethod.GET})
    public String verifyEmail(Model model, @RequestParam(value="code") String code, RedirectAttributes redirectAttributes, HttpServletResponse httpServletResponse, HttpServletRequest request) {
        UaaUser user;
        Map<String, String> response;
        try {
            response = this.changeEmailService.completeVerification(code);
        }
        catch (UaaException e) {
            return this.handleExceptionConsideringAuthentication(model, httpServletResponse);
        }
        try {
            user = this.uaaUserDatabase.retrieveUserById(response.get("userId"));
        }
        catch (UsernameNotFoundException e) {
            return this.handleExceptionConsideringAuthentication(model, httpServletResponse);
        }
        String redirectLocation = response.get("redirect_url");
        if (SecurityContextHolder.getContext().getAuthentication() instanceof UaaAuthentication) {
            String authenticatedId = ((UaaAuthentication)SecurityContextHolder.getContext().getAuthentication()).getPrincipal().getId();
            if (authenticatedId.equals(user.getId())) {
                UaaAuthenticationDetails details = new UaaAuthenticationDetails(request);
                UaaAuthentication success = new UaaAuthentication(new UaaPrincipal(user), user.getAuthorities(), details);
                SecurityContextHolder.getContext().setAuthentication((Authentication)success);
            }
            if (redirectLocation == null) {
                redirectLocation = "profile";
                redirectAttributes.addAttribute("success_message_code", (Object)"email_change.success");
            }
            return "redirect:" + redirectLocation;
        }
        if (redirectLocation == null) {
            return "redirect:login?success=change_email_success";
        }
        return "redirect:login?success=change_email_success&form_redirect_uri=" + redirectLocation;
    }

    private String handleExceptionConsideringAuthentication(Model model, HttpServletResponse httpServletResponse) {
        if (SecurityContextHolder.getContext().getAuthentication() instanceof AnonymousAuthenticationToken) {
            model.addAttribute("error_message_code", (Object)"email_change.invalid_code");
            httpServletResponse.setStatus(422);
            return "error";
        }
        return "redirect:profile?error_message_code=email_change.invalid_code";
    }

    public static class ValidEmail {
        @Email
        String newEmail;

        public String getNewEmail() {
            return this.newEmail;
        }

        public void setNewEmail(String email) {
            this.newEmail = email;
        }
    }
}

