/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.account;

import java.util.Date;
import java.util.List;
import org.cloudfoundry.identity.uaa.account.ChangePasswordService;
import org.cloudfoundry.identity.uaa.account.event.PasswordChangeEvent;
import org.cloudfoundry.identity.uaa.account.event.PasswordChangeFailureEvent;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidPasswordException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.cloudfoundry.identity.uaa.scim.validate.PasswordValidator;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.context.SecurityContextHolder;

public class UaaChangePasswordService
implements ChangePasswordService,
ApplicationEventPublisherAware {
    private final ScimUserProvisioning scimUserProvisioning;
    private final PasswordValidator passwordValidator;
    private ApplicationEventPublisher publisher;

    public UaaChangePasswordService(ScimUserProvisioning scimUserProvisioning, PasswordValidator passwordValidator) {
        this.scimUserProvisioning = scimUserProvisioning;
        this.passwordValidator = passwordValidator;
    }

    @Override
    public void changePassword(String username, String currentPassword, String newPassword) {
        if (username == null || currentPassword == null) {
            throw new BadCredentialsException(username);
        }
        this.passwordValidator.validate(newPassword);
        List results = this.scimUserProvisioning.query("userName eq \"" + username + "\"", IdentityZoneHolder.get().getId());
        if (results.isEmpty()) {
            throw new ScimResourceNotFoundException("User not found");
        }
        ScimUser user = (ScimUser)results.get(0);
        UaaUser uaaUser = this.getUaaUser(user);
        try {
            if (this.scimUserProvisioning.checkPasswordMatches(user.getId(), newPassword, IdentityZoneHolder.get().getId())) {
                throw new InvalidPasswordException("Your new password cannot be the same as the old password.", HttpStatus.UNPROCESSABLE_ENTITY);
            }
            this.scimUserProvisioning.changePassword(user.getId(), currentPassword, newPassword, IdentityZoneHolder.get().getId());
            this.publish(new PasswordChangeEvent("Password changed", uaaUser, SecurityContextHolder.getContext().getAuthentication()));
        }
        catch (Exception e) {
            this.publish(new PasswordChangeFailureEvent(e.getMessage(), uaaUser, SecurityContextHolder.getContext().getAuthentication()));
            throw e;
        }
    }

    private UaaUser getUaaUser(ScimUser scimUser) {
        Date today = new Date();
        return new UaaUser(scimUser.getId(), scimUser.getUserName(), "N/A", scimUser.getPrimaryEmail(), null, scimUser.getGivenName(), scimUser.getFamilyName(), today, today, scimUser.getOrigin(), scimUser.getExternalId(), scimUser.isVerified(), scimUser.getZoneId(), scimUser.getSalt(), scimUser.getPasswordLastModified());
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    protected void publish(ApplicationEvent event) {
        if (this.publisher != null) {
            this.publisher.publishEvent(event);
        }
    }
}

