/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.manager.ExternalGroupAuthorizationEvent;
import org.cloudfoundry.identity.uaa.authentication.manager.ExternalLoginAuthenticationManager;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.LdapIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.ldap.ExtendedLdapUserDetails;
import org.cloudfoundry.identity.uaa.provider.ldap.extension.LdapAuthority;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.util.ObjectUtils;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.MultiValueMap;

public class LdapLoginAuthenticationManager
extends ExternalLoginAuthenticationManager {
    protected static Log logger = LogFactory.getLog(LdapLoginAuthenticationManager.class);

    public LdapLoginAuthenticationManager(IdentityProviderProvisioning providerProvisioning) {
        super(providerProvisioning);
    }

    protected void populateAuthenticationAttributes(UaaAuthentication authentication, Authentication request, Object authenticationData) {
        super.populateAuthenticationAttributes(authentication, request, authenticationData);
        authentication.getAuthenticationMethods().add("pwd");
    }

    @Override
    protected MultiValueMap<String, String> getUserAttributes(UserDetails request) {
        MultiValueMap<String, String> result = super.getUserAttributes(request);
        logger.debug((Object)String.format("Mapping custom attributes for origin:%s and zone:%s", this.getOrigin(), IdentityZoneHolder.get().getId()));
        if (this.getProviderProvisioning() != null) {
            IdentityProvider provider = this.getProviderProvisioning().retrieveByOrigin(this.getOrigin(), IdentityZoneHolder.get().getId());
            if (request instanceof ExtendedLdapUserDetails) {
                ExtendedLdapUserDetails ldapDetails = (ExtendedLdapUserDetails)request;
                LdapIdentityProviderDefinition ldapIdentityProviderDefinition = (LdapIdentityProviderDefinition)ObjectUtils.castInstance((Object)provider.getConfig(), LdapIdentityProviderDefinition.class);
                Map providerMappings = ldapIdentityProviderDefinition.getAttributeMappings();
                for (Map.Entry entry : providerMappings.entrySet()) {
                    if (!((String)entry.getKey()).startsWith("user.attribute.") || entry.getValue() == null) continue;
                    String key = ((String)entry.getKey()).substring("user.attribute.".length());
                    String[] values = ldapDetails.getAttribute((String)entry.getValue(), false);
                    if (values == null || values.length <= 0) continue;
                    result.put((Object)key, Arrays.asList(values));
                    logger.debug((Object)String.format("Mappcustom attribute key:%s and value:%s", key, result.get((Object)key)));
                }
            }
        } else {
            logger.debug((Object)String.format("Did not find custom attribute configuration for origin:%s and zone:%s", this.getOrigin(), IdentityZoneHolder.get().getId()));
        }
        return result;
    }

    @Override
    protected List<String> getExternalUserAuthorities(UserDetails request) {
        List<String> result = super.getExternalUserAuthorities(request);
        if (this.getProviderProvisioning() != null) {
            IdentityProvider provider = this.getProviderProvisioning().retrieveByOrigin(this.getOrigin(), IdentityZoneHolder.get().getId());
            LdapIdentityProviderDefinition ldapIdentityProviderDefinition = (LdapIdentityProviderDefinition)ObjectUtils.castInstance((Object)provider.getConfig(), LdapIdentityProviderDefinition.class);
            List externalWhiteList = ldapIdentityProviderDefinition.getExternalGroupsWhitelist();
            result = new ArrayList<String>(UaaStringUtils.retainAllMatches(this.getAuthoritesAsNames(request.getAuthorities()), (Collection)externalWhiteList));
        }
        return result;
    }

    protected Set<String> getAuthoritesAsNames(Collection<? extends GrantedAuthority> authorities) {
        HashSet<String> result = new HashSet<String>();
        authorities = new LinkedList(authorities != null ? authorities : Collections.EMPTY_LIST);
        for (GrantedAuthority a : authorities) {
            LdapAuthority la;
            String[] groupNames;
            if (!(a instanceof LdapAuthority) || (groupNames = (la = (LdapAuthority)a).getAttributeValues("cn")) == null) continue;
            result.addAll(Arrays.asList(groupNames));
        }
        return result;
    }

    @Override
    protected UaaUser userAuthenticated(Authentication request, UaaUser userFromRequest, UaaUser userFromDb) {
        boolean userModified = false;
        if (request.getPrincipal() != null && request.getPrincipal() instanceof ExtendedLdapUserDetails && this.haveUserAttributesChanged(userFromDb, userFromRequest)) {
            userFromDb = userFromDb.modifyAttributes(userFromRequest.getEmail(), userFromRequest.getGivenName(), userFromRequest.getFamilyName(), userFromRequest.getPhoneNumber()).modifyUsername(userFromRequest.getUsername());
            userModified = true;
        }
        ExternalGroupAuthorizationEvent event = new ExternalGroupAuthorizationEvent(userFromDb, userModified, request.getAuthorities(), this.isAutoAddAuthorities());
        this.publish(event);
        return this.getUserDatabase().retrieveUserById(userFromDb.getId());
    }

    protected boolean isAutoAddAuthorities() {
        IdentityProvider provider;
        LdapIdentityProviderDefinition ldapIdentityProviderDefinition;
        Boolean result = true;
        if (this.getProviderProvisioning() != null && (ldapIdentityProviderDefinition = (LdapIdentityProviderDefinition)ObjectUtils.castInstance((Object)(provider = this.getProviderProvisioning().retrieveByOrigin(this.getOrigin(), IdentityZoneHolder.get().getId())).getConfig(), LdapIdentityProviderDefinition.class)) != null) {
            result = ldapIdentityProviderDefinition.isAutoAddGroups();
        }
        return result != null ? result : true;
    }

    @Override
    protected boolean isAddNewShadowUser() {
        IdentityProvider provider;
        LdapIdentityProviderDefinition ldapIdentityProviderDefinition;
        Boolean result = true;
        if (this.getProviderProvisioning() != null && (ldapIdentityProviderDefinition = (LdapIdentityProviderDefinition)ObjectUtils.castInstance((Object)(provider = this.getProviderProvisioning().retrieveByOrigin(this.getOrigin(), IdentityZoneHolder.get().getId())).getConfig(), LdapIdentityProviderDefinition.class)) != null) {
            result = ldapIdentityProviderDefinition.isAddShadowUserOnLogin();
        }
        return result != null ? result : true;
    }
}

