/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.AuthzAuthenticationRequest;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.authentication.event.IdentityProviderAuthenticationSuccessEvent;
import org.cloudfoundry.identity.uaa.authentication.manager.NewUserAuthenticatedEvent;
import org.cloudfoundry.identity.uaa.user.UaaAuthority;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;
import org.springframework.security.oauth2.provider.OAuth2Authentication;

public class LoginAuthenticationManager
implements AuthenticationManager,
ApplicationEventPublisherAware {
    public static final String NotANumber = "NaN";
    private final Log logger = LogFactory.getLog(this.getClass());
    private ApplicationEventPublisher eventPublisher;
    private UaaUserDatabase userDatabase;
    private RandomValueStringGenerator generator = new RandomValueStringGenerator();

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setUserDatabase(UaaUserDatabase userDatabase) {
        this.userDatabase = userDatabase;
    }

    public Authentication authenticate(Authentication request) throws AuthenticationException {
        OAuth2Authentication authentication;
        if (!(request instanceof AuthzAuthenticationRequest)) {
            this.logger.debug((Object)("Cannot process request of type: " + request.getClass().getName()));
            return null;
        }
        AuthzAuthenticationRequest req = (AuthzAuthenticationRequest)request;
        Map<String, String> info = req.getInfo();
        this.logger.debug((Object)("Processing authentication request for " + req.getName()));
        SecurityContext context = SecurityContextHolder.getContext();
        if (context.getAuthentication() instanceof OAuth2Authentication && (authentication = (OAuth2Authentication)context.getAuthentication()).isClientOnly()) {
            UaaUser user = this.getUser(req, info);
            UaaAuthenticationDetails authdetails = (UaaAuthenticationDetails)req.getDetails();
            boolean addNewAccounts = authdetails != null && authdetails.isAddNew();
            try {
                if (NotANumber.equals(user.getId())) {
                    user = this.userDatabase.retrieveUserByName(user.getUsername(), user.getOrigin());
                } else {
                    addNewAccounts = false;
                    user = this.userDatabase.retrieveUserById(user.getId());
                }
            }
            catch (UsernameNotFoundException e) {
                if (addNewAccounts) {
                    this.publish(new NewUserAuthenticatedEvent(user));
                    try {
                        user = this.userDatabase.retrieveUserByName(user.getUsername(), user.getOrigin());
                    }
                    catch (UsernameNotFoundException ex) {
                        throw new BadCredentialsException("Bad credentials");
                    }
                }
                throw new BadCredentialsException("Bad Credentials");
            }
            UaaAuthentication success = new UaaAuthentication(new UaaPrincipal(user), user.getAuthorities(), authdetails);
            this.publish(new IdentityProviderAuthenticationSuccessEvent(user, (Authentication)success));
            return success;
        }
        this.logger.debug((Object)"Did not locate login credentials");
        return null;
    }

    protected void publish(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    protected UaaUser getUser(AuthzAuthenticationRequest req, Map<String, String> info) {
        String familyName;
        String givenName;
        String origin;
        String userId;
        String name = req.getName();
        String email = info.get("email");
        String string = userId = info.get("user_id") != null ? info.get("user_id") : NotANumber;
        if (info.get("origin") != null && info.get("origin").equals("uaa")) {
            throw new BadCredentialsException("uaa origin not allowed for external login server");
        }
        String string2 = origin = info.get("origin") != null ? info.get("origin") : "login-server";
        if (name == null && email != null) {
            name = email;
        }
        if (name == null && NotANumber.equals(userId)) {
            throw new BadCredentialsException("Cannot determine username from credentials supplied");
        }
        if (name == null) {
            name = "unknown";
        }
        if (email == null) {
            email = name.contains("@") ? (name.split("@").length == 2 && !name.startsWith("@") && !name.endsWith("@") ? name : name.replaceAll("@", "") + "@unknown.org") : name + "@unknown.org";
        }
        if ((givenName = info.get("given_name")) == null) {
            givenName = email.split("@")[0];
        }
        if ((familyName = info.get("family_name")) == null) {
            familyName = email.split("@").length > 1 ? email.split("@")[1] : email;
        }
        return new UaaUser(userId, name, "", email, UaaAuthority.USER_AUTHORITIES, givenName, familyName, new Date(), new Date(), origin, name, false, IdentityZoneHolder.get().getId(), null, null);
    }
}

