/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.mfa;

import com.google.zxing.WriterException;
import com.warrenstrange.googleauth.GoogleAuthenticator;
import com.warrenstrange.googleauth.GoogleAuthenticatorKey;
import java.io.IOException;
import org.cloudfoundry.identity.uaa.mfa.MfaCredentialsSessionCache;
import org.cloudfoundry.identity.uaa.mfa.MfaRegisterQRGenerator;
import org.cloudfoundry.identity.uaa.mfa.UserGoogleMfaCredentials;

public class GoogleAuthenticatorAdapter {
    private GoogleAuthenticator authenticator;
    private MfaCredentialsSessionCache credCache;

    public String getOtpAuthURL(String qrIssuer, String userId, String userName) throws IOException, WriterException {
        UserGoogleMfaCredentials credentials = this.credCache.getCredentials();
        if (credentials == null) {
            GoogleAuthenticatorKey newCredentials = this.authenticator.createCredentials(userId);
            return MfaRegisterQRGenerator.getQRCodePngDataUri(qrIssuer, userName, newCredentials.getKey());
        }
        return MfaRegisterQRGenerator.getQRCodePngDataUri(qrIssuer, userName, credentials.getSecretKey());
    }

    public String getOtpSecret(String userId) {
        UserGoogleMfaCredentials credentials = this.credCache.getCredentials();
        if (credentials == null) {
            return this.authenticator.createCredentials(userId).getKey();
        }
        return credentials.getSecretKey();
    }

    public boolean isValidCode(String userId, Integer code) {
        return this.authenticator.authorizeUser(userId, code.intValue());
    }

    public void setAuthenticator(GoogleAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setCredCache(MfaCredentialsSessionCache credCache) {
        this.credCache = credCache;
    }
}

