/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpHost;
import org.apache.http.client.utils.URIUtils;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.oauth.DisallowedIdpException;
import org.cloudfoundry.identity.uaa.oauth.HybridTokenGranterForAuthorizationCode;
import org.cloudfoundry.identity.uaa.oauth.OpenIdSessionStateCalculator;
import org.cloudfoundry.identity.uaa.oauth.token.CompositeAccessToken;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.UaaHttpRequestUtils;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.BadClientCredentialsException;
import org.springframework.security.oauth2.common.exceptions.ClientAuthenticationException;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.InvalidRequestException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.RedirectMismatchException;
import org.springframework.security.oauth2.common.exceptions.UnapprovedClientAuthenticationException;
import org.springframework.security.oauth2.common.exceptions.UnauthorizedClientException;
import org.springframework.security.oauth2.common.exceptions.UnsupportedResponseTypeException;
import org.springframework.security.oauth2.common.exceptions.UserDeniedAuthorizationException;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.OAuth2RequestValidator;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.approval.DefaultUserApprovalHandler;
import org.springframework.security.oauth2.provider.approval.UserApprovalHandler;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.code.InMemoryAuthorizationCodeServices;
import org.springframework.security.oauth2.provider.endpoint.AbstractEndpoint;
import org.springframework.security.oauth2.provider.endpoint.RedirectResolver;
import org.springframework.security.oauth2.provider.implicit.ImplicitGrantService;
import org.springframework.security.oauth2.provider.implicit.ImplicitTokenRequest;
import org.springframework.security.oauth2.provider.request.DefaultOAuth2RequestValidator;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.DefaultSessionAttributeStore;
import org.springframework.web.bind.support.SessionAttributeStore;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

@Controller
@SessionAttributes(value={"authorizationRequest"})
public class UaaAuthorizationEndpoint
extends AbstractEndpoint
implements AuthenticationEntryPoint {
    private AuthorizationCodeServices authorizationCodeServices = new InMemoryAuthorizationCodeServices();
    private RedirectResolver redirectResolver;
    private UserApprovalHandler userApprovalHandler = new DefaultUserApprovalHandler();
    private SessionAttributeStore sessionAttributeStore = new DefaultSessionAttributeStore();
    private OAuth2RequestValidator oauth2RequestValidator = new DefaultOAuth2RequestValidator();
    private String userApprovalPage = "forward:/oauth/confirm_access";
    private String errorPage = "forward:/oauth/error";
    private Object implicitLock = new Object();
    private HybridTokenGranterForAuthorizationCode hybridTokenGranterForAuthCode;
    private OpenIdSessionStateCalculator openIdSessionStateCalculator;
    private static final List<String> supported_response_types = Arrays.asList("code", "token", "id_token");

    @RequestMapping(value={"/oauth/authorize"})
    public ModelAndView authorize(Map<String, Object> model, @RequestParam Map<String, String> parameters, SessionStatus sessionStatus, Principal principal, HttpServletRequest request) {
        AuthorizationRequest authorizationRequest;
        ClientDetails client;
        String clientId;
        try {
            clientId = parameters.get("client_id");
            client = this.getClientServiceExtention().loadClientByClientId(clientId, IdentityZoneHolder.get().getId());
        }
        catch (NoSuchClientException x) {
            throw new InvalidClientException(x.getMessage());
        }
        try {
            authorizationRequest = this.getOAuth2RequestFactory().createAuthorizationRequest(parameters);
        }
        catch (DisallowedIdpException x) {
            return this.switchIdp(model, client, clientId, request);
        }
        Set responseTypes = authorizationRequest.getResponseTypes();
        String grantType = this.deriveGrantTypeFromResponseType(responseTypes);
        if (!supported_response_types.containsAll(responseTypes)) {
            throw new UnsupportedResponseTypeException("Unsupported response types: " + responseTypes);
        }
        if (authorizationRequest.getClientId() == null) {
            throw new InvalidClientException("A client id must be provided");
        }
        String resolvedRedirect = "";
        try {
            boolean isAuthenticated;
            String redirectUriParameter = (String)authorizationRequest.getRequestParameters().get("redirect_uri");
            try {
                resolvedRedirect = this.redirectResolver.resolveRedirect(redirectUriParameter, client);
            }
            catch (RedirectMismatchException rme) {
                throw new RedirectMismatchException("Invalid redirect " + redirectUriParameter + " did not match one of the registered values");
            }
            if (!StringUtils.hasText((String)resolvedRedirect)) {
                throw new RedirectMismatchException("A redirectUri must be either supplied or preconfigured in the ClientDetails");
            }
            boolean bl = isAuthenticated = principal instanceof Authentication && ((Authentication)principal).isAuthenticated();
            if (!isAuthenticated) {
                throw new InsufficientAuthenticationException("User must be authenticated with Spring Security before authorization can be completed.");
            }
            authorizationRequest.setRedirectUri(resolvedRedirect);
            this.oauth2RequestValidator.validateScope(authorizationRequest, client);
            authorizationRequest = this.userApprovalHandler.checkForPreApproval(authorizationRequest, (Authentication)principal);
            boolean approved = this.userApprovalHandler.isApproved(authorizationRequest, (Authentication)principal);
            authorizationRequest.setApproved(approved);
            if (authorizationRequest.isApproved()) {
                if (responseTypes.contains("token") || responseTypes.contains("id_token")) {
                    return this.getImplicitGrantOrHybridResponse(authorizationRequest, (Authentication)principal, grantType);
                }
                if (responseTypes.contains("code")) {
                    return new ModelAndView(this.getAuthorizationCodeResponse(authorizationRequest, (Authentication)principal));
                }
            }
            if ("none".equals(authorizationRequest.getRequestParameters().get("prompt"))) {
                return new ModelAndView((View)new RedirectView(UaaUrlUtils.addFragmentComponent(resolvedRedirect, "error=interaction_required")));
            }
            model.put("authorizationRequest", authorizationRequest);
            model.put("original_uri", UrlUtils.buildFullRequestUrl((HttpServletRequest)request));
            return this.getUserApprovalPageResponse(model, authorizationRequest, (Authentication)principal);
        }
        catch (RedirectMismatchException e) {
            sessionStatus.setComplete();
            throw e;
        }
        catch (Exception e) {
            sessionStatus.setComplete();
            if ("none".equals(authorizationRequest.getRequestParameters().get("prompt"))) {
                return new ModelAndView((View)new RedirectView(UaaUrlUtils.addFragmentComponent(resolvedRedirect, "error=internal_server_error")));
            }
            throw e;
        }
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        String redirectLocation;
        String resolvedRedirect;
        ClientDetails client;
        String clientId = request.getParameter("client_id");
        String redirectUri = request.getParameter("redirect_uri");
        String[] responseTypes = Optional.ofNullable(request.getParameter("response_type")).map(rt -> rt.split(" ")).orElse(new String[0]);
        try {
            client = this.getClientServiceExtention().loadClientByClientId(clientId, IdentityZoneHolder.get().getId());
        }
        catch (ClientRegistrationException e) {
            this.logger.debug((Object)("[prompt=none] Unable to look up client for client_id=" + clientId), (Throwable)e);
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        Set redirectUris = Optional.ofNullable(client.getRegisteredRedirectUri()).orElse(Collections.EMPTY_SET);
        if (redirectUris.size() == 0 && !JsonUtils.hasText((CharSequence)redirectUri)) {
            this.logger.debug((Object)"[prompt=none] Missing redirect_uri");
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        try {
            resolvedRedirect = this.redirectResolver.resolveRedirect(redirectUri, client);
        }
        catch (RedirectMismatchException rme) {
            this.logger.debug((Object)("[prompt=none] Invalid redirect " + redirectUri + " did not match one of the registered values"));
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        HttpHost httpHost = URIUtils.extractHost((URI)URI.create(resolvedRedirect));
        String sessionState = this.openIdSessionStateCalculator.calculate("", clientId, httpHost.toURI());
        boolean implicit = Arrays.stream(responseTypes).noneMatch("code"::equalsIgnoreCase);
        if (implicit) {
            redirectLocation = UaaUrlUtils.addFragmentComponent(resolvedRedirect, "error=login_required");
            redirectLocation = UaaUrlUtils.addFragmentComponent(redirectLocation, "session_state=" + sessionState);
        } else {
            redirectLocation = UaaUrlUtils.addQueryParameter(resolvedRedirect, "error", "login_required");
            redirectLocation = UaaUrlUtils.addQueryParameter(redirectLocation, "session_state", sessionState);
        }
        response.sendRedirect(redirectLocation);
    }

    private ModelAndView switchIdp(Map<String, Object> model, ClientDetails client, String clientId, HttpServletRequest request) {
        Map additionalInfo = client.getAdditionalInformation();
        String clientDisplayName = (String)additionalInfo.get("name");
        model.put("client_display_name", clientDisplayName != null ? clientDisplayName : clientId);
        String queryString = UaaHttpRequestUtils.paramsToQueryString(request.getParameterMap());
        String redirectUri = request.getRequestURL() + "?" + queryString;
        model.put("redirect", redirectUri);
        model.put("error", "The application is not authorized for your account.");
        model.put("error_message_code", "login.invalid_idp");
        return new ModelAndView("switch_idp", model, HttpStatus.UNAUTHORIZED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/oauth/authorize"}, method={RequestMethod.POST}, params={"user_oauth_approval"})
    public View approveOrDeny(@RequestParam Map<String, String> approvalParameters, Map<String, ?> model, SessionStatus sessionStatus, Principal principal) {
        if (!(principal instanceof Authentication)) {
            sessionStatus.setComplete();
            throw new InsufficientAuthenticationException("User must be authenticated with Spring Security before authorizing an access token.");
        }
        AuthorizationRequest authorizationRequest = (AuthorizationRequest)model.get("authorizationRequest");
        if (authorizationRequest == null) {
            sessionStatus.setComplete();
            throw new InvalidRequestException("Cannot approve uninitialized authorization request.");
        }
        try {
            Set responseTypes = authorizationRequest.getResponseTypes();
            String grantType = this.deriveGrantTypeFromResponseType(responseTypes);
            authorizationRequest.setApprovalParameters(approvalParameters);
            authorizationRequest = this.userApprovalHandler.updateAfterApproval(authorizationRequest, (Authentication)principal);
            boolean approved = this.userApprovalHandler.isApproved(authorizationRequest, (Authentication)principal);
            authorizationRequest.setApproved(approved);
            if (authorizationRequest.getRedirectUri() == null) {
                sessionStatus.setComplete();
                throw new InvalidRequestException("Cannot approve request when no redirect URI is provided.");
            }
            if (!authorizationRequest.isApproved()) {
                RedirectView redirectView = new RedirectView(this.getUnsuccessfulRedirect(authorizationRequest, (OAuth2Exception)new UserDeniedAuthorizationException("User denied access"), responseTypes.contains("token")), false, true, false);
                return redirectView;
            }
            if (responseTypes.contains("token") || responseTypes.contains("id_token")) {
                View view = this.getImplicitGrantOrHybridResponse(authorizationRequest, (Authentication)principal, grantType).getView();
                return view;
            }
            View view = this.getAuthorizationCodeResponse(authorizationRequest, (Authentication)principal);
            return view;
        }
        finally {
            sessionStatus.setComplete();
        }
    }

    protected String deriveGrantTypeFromResponseType(Set<String> responseTypes) {
        if (responseTypes.contains("token")) {
            return "implicit";
        }
        if (responseTypes.size() == 1 && responseTypes.contains("id_token")) {
            return "implicit";
        }
        return "authorization_code";
    }

    private ModelAndView getUserApprovalPageResponse(Map<String, Object> model, AuthorizationRequest authorizationRequest, Authentication principal) {
        this.logger.debug((Object)("Loading user approval page: " + this.userApprovalPage));
        model.putAll(this.userApprovalHandler.getUserApprovalRequest(authorizationRequest, principal));
        return new ModelAndView(this.userApprovalPage, model);
    }

    private ModelAndView getImplicitGrantOrHybridResponse(AuthorizationRequest authorizationRequest, Authentication authentication, String grantType) {
        try {
            TokenRequest tokenRequest = this.getOAuth2RequestFactory().createTokenRequest(authorizationRequest, "implicit");
            OAuth2Request storedOAuth2Request = this.getOAuth2RequestFactory().createOAuth2Request(authorizationRequest);
            OAuth2AccessToken accessToken = this.getAccessTokenForImplicitGrantOrHybrid(tokenRequest, storedOAuth2Request, grantType);
            if (accessToken == null) {
                throw new UnsupportedResponseTypeException("Unsupported response type: token or id_token");
            }
            return new ModelAndView((View)new RedirectView(this.buildRedirectURI(authorizationRequest, accessToken, authentication), false, true, false));
        }
        catch (OAuth2Exception e) {
            return new ModelAndView((View)new RedirectView(this.getUnsuccessfulRedirect(authorizationRequest, e, true), false, true, false));
        }
    }

    private OAuth2AccessToken getAccessTokenForImplicitGrantOrHybrid(TokenRequest tokenRequest, OAuth2Request storedOAuth2Request, String grantType) throws OAuth2Exception {
        Object object = this.implicitLock;
        synchronized (object) {
            switch (grantType) {
                case "implicit": {
                    return this.getTokenGranter().grant(grantType, (TokenRequest)new ImplicitTokenRequest(tokenRequest, storedOAuth2Request));
                }
                case "authorization_code": {
                    return this.getHybridTokenGranterForAuthCode().grant(grantType, (TokenRequest)new ImplicitTokenRequest(tokenRequest, storedOAuth2Request));
                }
            }
            throw new OAuth2Exception("invalid_grant");
        }
    }

    private View getAuthorizationCodeResponse(AuthorizationRequest authorizationRequest, Authentication authUser) {
        try {
            return new RedirectView(this.getSuccessfulRedirect(authorizationRequest, this.generateCode(authorizationRequest, authUser)), false, false, false){

                protected HttpStatus getHttp11StatusCode(HttpServletRequest request, HttpServletResponse response, String targetUrl) {
                    return HttpStatus.FOUND;
                }
            };
        }
        catch (OAuth2Exception e) {
            return new RedirectView(this.getUnsuccessfulRedirect(authorizationRequest, e, false), false, true, false);
        }
    }

    public String buildRedirectURI(AuthorizationRequest authorizationRequest, OAuth2AccessToken accessToken, Authentication authUser) {
        UriComponentsBuilder builder;
        String existingFragment;
        String originalScope;
        Date expiration;
        String state;
        String requestedRedirect = authorizationRequest.getRedirectUri();
        if (accessToken == null) {
            throw new InvalidRequestException("An implicit grant could not be made");
        }
        StringBuilder url = new StringBuilder();
        url.append("token_type=").append(this.encode(accessToken.getTokenType()));
        if (authorizationRequest.getResponseTypes().contains("token")) {
            url.append("&access_token=").append(this.encode(accessToken.getValue()));
        }
        if (accessToken instanceof CompositeAccessToken && authorizationRequest.getResponseTypes().contains(CompositeAccessToken.ID_TOKEN)) {
            url.append("&").append(CompositeAccessToken.ID_TOKEN).append("=").append(this.encode(((CompositeAccessToken)accessToken).getIdTokenValue()));
        }
        if (authorizationRequest.getResponseTypes().contains("code")) {
            String code = this.generateCode(authorizationRequest, authUser);
            url.append("&code=").append(this.encode(code));
        }
        if ((state = authorizationRequest.getState()) != null) {
            url.append("&state=").append(this.encode(state));
        }
        if ((expiration = accessToken.getExpiration()) != null) {
            long expires_in = (expiration.getTime() - System.currentTimeMillis()) / 1000L;
            url.append("&expires_in=").append(expires_in);
        }
        if ((originalScope = (String)authorizationRequest.getRequestParameters().get("scope")) == null || !OAuth2Utils.parseParameterList((String)originalScope).equals(accessToken.getScope())) {
            url.append("&scope=").append(this.encode(OAuth2Utils.formatParameterList((Collection)accessToken.getScope())));
        }
        Map additionalInformation = accessToken.getAdditionalInformation();
        for (String key : additionalInformation.keySet()) {
            Object value = additionalInformation.get(key);
            if (value == null) continue;
            url.append("&" + this.encode(key) + "=" + this.encode(value.toString()));
        }
        if ("none".equals(authorizationRequest.getRequestParameters().get("prompt"))) {
            HttpHost httpHost = URIUtils.extractHost((URI)URI.create(requestedRedirect));
            String sessionState = this.openIdSessionStateCalculator.calculate(((UaaPrincipal)authUser.getPrincipal()).getId(), authorizationRequest.getClientId(), httpHost.toURI());
            url.append("&session_state=").append(sessionState);
        }
        existingFragment = StringUtils.hasText((String)(existingFragment = (builder = UriComponentsBuilder.fromUriString((String)requestedRedirect)).build(true).getFragment())) ? existingFragment + "&" + url.toString() : url.toString();
        builder.fragment(existingFragment);
        return builder.build(true).toUriString();
    }

    private String generateCode(AuthorizationRequest authorizationRequest, Authentication authentication) throws AuthenticationException {
        try {
            OAuth2Request storedOAuth2Request = this.getOAuth2RequestFactory().createOAuth2Request(authorizationRequest);
            OAuth2Authentication combinedAuth = new OAuth2Authentication(storedOAuth2Request, authentication);
            String code = this.authorizationCodeServices.createAuthorizationCode(combinedAuth);
            return code;
        }
        catch (OAuth2Exception e) {
            if (authorizationRequest.getState() != null) {
                e.addAdditionalInformation("state", authorizationRequest.getState());
            }
            throw e;
        }
    }

    private String encode(String value) {
        try {
            return UriUtils.encodeQueryParam((String)value, (String)"UTF-8");
        }
        catch (UnsupportedEncodingException x) {
            throw new IllegalArgumentException(x);
        }
    }

    private String getSuccessfulRedirect(AuthorizationRequest authorizationRequest, String authorizationCode) {
        if (authorizationCode == null) {
            throw new IllegalStateException("No authorization code found in the current request scope.");
        }
        UriComponentsBuilder template = UriComponentsBuilder.fromUriString((String)authorizationRequest.getRedirectUri());
        template.queryParam("code", new Object[]{this.encode(authorizationCode)});
        String state = authorizationRequest.getState();
        if (state != null) {
            template.queryParam("state", new Object[]{this.encode(state)});
        }
        return template.build(true).toUriString();
    }

    private String getUnsuccessfulRedirect(AuthorizationRequest authorizationRequest, OAuth2Exception failure, boolean fragment) {
        if (authorizationRequest == null || authorizationRequest.getRedirectUri() == null) {
            throw new UnapprovedClientAuthenticationException("Authorization failure, and no redirect URI.", (Throwable)failure);
        }
        UriComponentsBuilder template = UriComponentsBuilder.fromUriString((String)authorizationRequest.getRedirectUri());
        StringBuilder values = new StringBuilder();
        values.append("error=" + this.encode(failure.getOAuth2ErrorCode()));
        values.append("&error_description=" + this.encode(failure.getMessage()));
        if (authorizationRequest.getState() != null) {
            values.append("&state=" + this.encode(authorizationRequest.getState()));
        }
        if (failure.getAdditionalInformation() != null) {
            for (Map.Entry additionalInfo : failure.getAdditionalInformation().entrySet()) {
                values.append("&" + this.encode((String)additionalInfo.getKey()) + "=" + this.encode((String)additionalInfo.getValue()));
            }
        }
        if (fragment) {
            template.fragment(values.toString());
        } else {
            template.query(values.toString());
        }
        return template.build(true).toUriString();
    }

    public void setUserApprovalPage(String userApprovalPage) {
        this.userApprovalPage = userApprovalPage;
    }

    public void setAuthorizationCodeServices(AuthorizationCodeServices authorizationCodeServices) {
        this.authorizationCodeServices = authorizationCodeServices;
    }

    public void setRedirectResolver(RedirectResolver redirectResolver) {
        this.redirectResolver = redirectResolver;
    }

    public void setUserApprovalHandler(UserApprovalHandler userApprovalHandler) {
        this.userApprovalHandler = userApprovalHandler;
    }

    public void setOAuth2RequestValidator(OAuth2RequestValidator oauth2RequestValidator) {
        this.oauth2RequestValidator = oauth2RequestValidator;
    }

    public void setImplicitGrantService(ImplicitGrantService implicitGrantService) {
    }

    @ExceptionHandler(value={ClientRegistrationException.class})
    public ModelAndView handleClientRegistrationException(Exception e, ServletWebRequest webRequest) throws Exception {
        this.logger.info((Object)("Handling ClientRegistrationException error: " + e.getMessage()));
        return this.handleException((Exception)((Object)new BadClientCredentialsException()), webRequest);
    }

    @ExceptionHandler(value={OAuth2Exception.class})
    public ModelAndView handleOAuth2Exception(OAuth2Exception e, ServletWebRequest webRequest) throws Exception {
        this.logger.info((Object)("Handling OAuth2 error: " + e.getSummary()));
        return this.handleException((Exception)((Object)e), webRequest);
    }

    @ExceptionHandler(value={HttpSessionRequiredException.class})
    public ModelAndView handleHttpSessionRequiredException(HttpSessionRequiredException e, ServletWebRequest webRequest) throws Exception {
        this.logger.info((Object)("Handling Session required error: " + e.getMessage()));
        return this.handleException((Exception)new AccessDeniedException("Could not obtain authorization request from session", (Throwable)e), webRequest);
    }

    private ModelAndView handleException(Exception e, ServletWebRequest webRequest) throws Exception {
        ResponseEntity translate = this.getExceptionTranslator().translate(e);
        webRequest.getResponse().setStatus(translate.getStatusCode().value());
        if (e instanceof ClientAuthenticationException || e instanceof RedirectMismatchException) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("error", translate.getBody());
            if (e instanceof UnauthorizedClientException) {
                map.put("error_message_code", "login.invalid_idp");
            }
            return new ModelAndView(this.errorPage, map);
        }
        AuthorizationRequest authorizationRequest = null;
        try {
            authorizationRequest = this.getAuthorizationRequestForError(webRequest);
            String requestedRedirectParam = (String)authorizationRequest.getRequestParameters().get("redirect_uri");
            String requestedRedirect = this.redirectResolver.resolveRedirect(requestedRedirectParam, this.getClientServiceExtention().loadClientByClientId(authorizationRequest.getClientId(), IdentityZoneHolder.get().getId()));
            authorizationRequest.setRedirectUri(requestedRedirect);
            String redirect = this.getUnsuccessfulRedirect(authorizationRequest, (OAuth2Exception)((Object)translate.getBody()), authorizationRequest.getResponseTypes().contains("token"));
            return new ModelAndView((View)new RedirectView(redirect, false, true, false));
        }
        catch (OAuth2Exception ex) {
            return new ModelAndView(this.errorPage, Collections.singletonMap("error", translate.getBody()));
        }
    }

    private AuthorizationRequest getAuthorizationRequestForError(ServletWebRequest webRequest) {
        AuthorizationRequest authorizationRequest = (AuthorizationRequest)this.sessionAttributeStore.retrieveAttribute((WebRequest)webRequest, "authorizationRequest");
        if (authorizationRequest != null) {
            return authorizationRequest;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map map = webRequest.getParameterMap();
        for (String key : map.keySet()) {
            String[] values = (String[])map.get(key);
            if (values == null || values.length <= 0) continue;
            parameters.put(key, values[0]);
        }
        try {
            return this.getOAuth2RequestFactory().createAuthorizationRequest(parameters);
        }
        catch (Exception e) {
            return this.getDefaultOAuth2RequestFactory().createAuthorizationRequest(parameters);
        }
    }

    protected ClientServicesExtension getClientServiceExtention() {
        return (ClientServicesExtension)super.getClientDetailsService();
    }

    public void setClientDetailsService(ClientServicesExtension clientDetailsService) {
        super.setClientDetailsService((ClientDetailsService)clientDetailsService);
    }

    public HybridTokenGranterForAuthorizationCode getHybridTokenGranterForAuthCode() {
        return this.hybridTokenGranterForAuthCode;
    }

    public void setHybridTokenGranterForAuthCode(HybridTokenGranterForAuthorizationCode hybridTokenGranterForAuthCode) {
        this.hybridTokenGranterForAuthCode = hybridTokenGranterForAuthCode;
    }

    public void setSessionAttributeStore(SessionAttributeStore sessionAttributeStore) {
        this.sessionAttributeStore = sessionAttributeStore;
    }

    public void setErrorPage(String errorPage) {
        this.errorPage = errorPage;
    }

    public OpenIdSessionStateCalculator getOpenIdSessionStateCalculator() {
        return this.openIdSessionStateCalculator;
    }

    public void setOpenIdSessionStateCalculator(OpenIdSessionStateCalculator openIdSessionStateCalculator) {
        this.openIdSessionStateCalculator = openIdSessionStateCalculator;
    }
}

