/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.opensaml.xml.XMLObject;
import org.springframework.security.saml.storage.SAMLMessageStorage;

public class SamlMessageStorage
implements SAMLMessageStorage {
    private static Log logger = LogFactory.getLog(SamlMessageStorage.class);
    private ConcurrentMap<String, XMLObject> messages = new ConcurrentHashMap<String, XMLObject>();

    public void storeMessage(String messageId, XMLObject message) {
        logger.debug((Object)String.format("Storing SAML message with ID:%s for subdomain:%s", messageId, IdentityZoneHolder.get().getSubdomain()));
        XMLObject previous = this.messages.put(messageId, message);
        if (previous != null) {
            logger.warn((Object)String.format("SAML message replaced, it already exists with ID:%s for subdomain:%s.", messageId, IdentityZoneHolder.get().getSubdomain()));
        }
    }

    public XMLObject retrieveMessage(String messageId) {
        XMLObject result = (XMLObject)this.messages.remove(messageId);
        logger.debug((Object)String.format("%s - Retrieving SAML message with ID:%s for subdomain:%s", result == null ? "Failure" : "Success", messageId, IdentityZoneHolder.get().getSubdomain()));
        return result;
    }
}

