/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.login;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.account.PasswordConfirmationValidation;
import org.cloudfoundry.identity.uaa.account.ResetPasswordService;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidPasswordException;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ForcePasswordChangeController {
    private ResourcePropertySource resourcePropertySource;
    public static final String FORCE_PASSWORD_EXPIRED_USER = "FORCE_PASSWORD_EXPIRED_USER";
    private Log logger = LogFactory.getLog(this.getClass());
    @Autowired
    @Qualifier(value="resetPasswordService")
    private ResetPasswordService resetPasswordService;

    @RequestMapping(value={"/force_password_change"}, method={RequestMethod.GET})
    public String forcePasswordChangePage(Model model) throws IOException {
        String email = ((UaaAuthentication)SecurityContextHolder.getContext().getAuthentication()).getPrincipal().getEmail();
        model.addAttribute("email", (Object)email);
        return "force_password_change";
    }

    @RequestMapping(value={"/force_password_change"}, method={RequestMethod.POST})
    public String handleForcePasswordChange(Model model, @RequestParam(value="password") String password, @RequestParam(value="password_confirmation") String passwordConfirmation, HttpServletResponse response) throws IOException {
        UaaAuthentication authentication = (UaaAuthentication)SecurityContextHolder.getContext().getAuthentication();
        UaaPrincipal principal = authentication.getPrincipal();
        String email = principal.getEmail();
        PasswordConfirmationValidation validation = new PasswordConfirmationValidation(email, password, passwordConfirmation);
        if (!validation.valid()) {
            return this.handleUnprocessableEntity(model, response, email, this.resourcePropertySource.getProperty("force_password_change.form_error").toString());
        }
        this.logger.debug((Object)("Processing handleForcePasswordChange for user: " + email));
        try {
            this.resetPasswordService.resetUserPassword(principal.getId(), password);
        }
        catch (InvalidPasswordException exception) {
            return this.handleUnprocessableEntity(model, response, email, exception.getMessagesAsOneString());
        }
        this.logger.debug((Object)String.format("Successful password change for username:%s in zone:%s ", principal.getName(), IdentityZoneHolder.get().getId()));
        authentication.setRequiresPasswordChange(false);
        authentication.setAuthenticatedTime(System.currentTimeMillis());
        return "redirect:/force_password_change_completed";
    }

    public void setResetPasswordService(ResetPasswordService resetPasswordService) {
        this.resetPasswordService = resetPasswordService;
    }

    private String handleUnprocessableEntity(Model model, HttpServletResponse response, String email, String message) {
        model.addAttribute("message", (Object)message);
        model.addAttribute("email", (Object)email);
        response.setStatus(HttpStatus.UNPROCESSABLE_ENTITY.value());
        return "force_password_change";
    }

    public void setResourcePropertySource(ResourcePropertySource resourcePropertySource) {
        this.resourcePropertySource = resourcePropertySource;
    }
}

