/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.mfa;

import com.warrenstrange.googleauth.ICredentialRepository;
import java.util.List;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.mfa.MfaCredentialsSessionCache;
import org.cloudfoundry.identity.uaa.mfa.MfaProvider;
import org.cloudfoundry.identity.uaa.mfa.MfaProviderProvisioning;
import org.cloudfoundry.identity.uaa.mfa.UserGoogleMfaCredentials;
import org.cloudfoundry.identity.uaa.mfa.UserMfaCredentialsProvisioning;
import org.cloudfoundry.identity.uaa.mfa.exception.UserMfaConfigDoesNotExistException;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;

public class UserGoogleMfaCredentialsProvisioning
implements ICredentialRepository {
    private MfaProviderProvisioning mfaProviderProvisioning;
    private MfaCredentialsSessionCache credCache;
    UserMfaCredentialsProvisioning<UserGoogleMfaCredentials> jdbcProvisioner;

    public String getSecretKey(String userId) {
        UserGoogleMfaCredentials creds = this.credCache.getCredentials();
        if (creds == null) {
            MfaProvider provider = this.mfaProviderProvisioning.retrieveByName(IdentityZoneHolder.get().getConfig().getMfaConfig().getProviderName(), IdentityZoneHolder.get().getId());
            creds = this.jdbcProvisioner.retrieve(userId, provider.getId());
        }
        return creds.getSecretKey();
    }

    public void saveUserCredentials(String userName, String secretKey, int validationCode, List<Integer> scratchCodes) {
        UserGoogleMfaCredentials creds = new UserGoogleMfaCredentials(userName, secretKey, validationCode, scratchCodes);
        MfaProvider mfaProvider = this.mfaProviderProvisioning.retrieveByName(IdentityZoneHolder.get().getConfig().getMfaConfig().getProviderName(), IdentityZoneHolder.get().getId());
        creds.setMfaProviderId(mfaProvider.getId());
        this.credCache.putCredentials(creds);
    }

    public boolean activeUserCredentialExists(String userId, String mfaProviderId) {
        UserGoogleMfaCredentials retrieved;
        try {
            retrieved = this.jdbcProvisioner.retrieve(userId, mfaProviderId);
        }
        catch (UserMfaConfigDoesNotExistException e) {
            return false;
        }
        return retrieved != null;
    }

    public void persistCredentials() {
        String zoneId = IdentityZoneHolder.get().getId();
        UserGoogleMfaCredentials creds = this.credCache.getCredentials();
        if (creds == null) {
            return;
        }
        MfaProvider mfaProvider = this.mfaProviderProvisioning.retrieveByName(IdentityZoneHolder.get().getConfig().getMfaConfig().getProviderName(), zoneId);
        creds.setMfaProviderId(mfaProvider.getId());
        this.jdbcProvisioner.save(creds, zoneId);
        this.credCache.removeCredentials();
    }

    public boolean isFirstTimeMFAUser(UaaPrincipal uaaPrincipal) {
        if (uaaPrincipal == null) {
            throw new RuntimeException("User information is not present in session.");
        }
        return this.credCache.getCredentials() != null;
    }

    public void setJdbcProvisioner(UserMfaCredentialsProvisioning<UserGoogleMfaCredentials> jdbcProvisioner) {
        this.jdbcProvisioner = jdbcProvisioner;
    }

    public void setMfaProviderProvisioning(MfaProviderProvisioning mfaProviderProvisioning) {
        this.mfaProviderProvisioning = mfaProviderProvisioning;
    }

    public void setCredCache(MfaCredentialsSessionCache credCache) {
        this.credCache = credCache;
    }
}

