/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.RedirectMismatchException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.endpoint.DefaultRedirectResolver;
import org.springframework.util.AntPathMatcher;

public class AntPathRedirectResolver
extends DefaultRedirectResolver {
    protected boolean redirectMatches(String requestedRedirect, String redirectUri) {
        AntPathMatcher matcher = new AntPathMatcher("/");
        if (redirectUri != null && redirectUri.contains("*") && matcher.match(redirectUri, requestedRedirect)) {
            return true;
        }
        return super.redirectMatches(requestedRedirect, redirectUri);
    }

    public String resolveRedirect(String requestedRedirect, ClientDetails client) throws OAuth2Exception {
        Set registeredRedirectUris = Optional.ofNullable(client.getRegisteredRedirectUri()).orElse(Collections.emptySet());
        if (registeredRedirectUris.size() == 0) {
            throw new RedirectMismatchException("Client registration is missing redirect_uri");
        }
        List invalidUrls = registeredRedirectUris.stream().filter(url -> !UaaUrlUtils.isValidRegisteredRedirectUrl(url)).collect(Collectors.toList());
        if (invalidUrls.size() > 0) {
            throw new RedirectMismatchException("Client registration contains invalid redirect_uri: " + invalidUrls);
        }
        return super.resolveRedirect(requestedRedirect, client);
    }
}

