/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.exception;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.identity.uaa.scim.exception.ScimException;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;

public class InvalidPasswordException
extends ScimException {
    private final List<String> errorMessages;

    public InvalidPasswordException(String message) {
        super(message, HttpStatus.BAD_REQUEST);
        this.errorMessages = Arrays.asList(message);
    }

    public InvalidPasswordException(List<String> errorMessages) {
        super(StringUtils.collectionToDelimitedString(errorMessages, (String)","), HttpStatus.BAD_REQUEST);
        this.errorMessages = errorMessages;
    }

    public InvalidPasswordException(String message, HttpStatus httpStatus) {
        super(message, httpStatus);
        this.errorMessages = Arrays.asList(message);
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public String getMessagesAsOneString() {
        ArrayList<String> sortedMessages = new ArrayList<String>(this.errorMessages);
        Collections.sort(sortedMessages);
        return StringUtils.collectionToDelimitedString(sortedMessages, (String)" ");
    }

    @Override
    public String getMessage() {
        return this.getMessagesAsOneString();
    }
}

