/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class PasswordChangeRequiredFilter
extends OncePerRequestFilter {
    private final String redirectUri;
    private final AntPathRequestMatcher matcher;
    private final List<AntPathRequestMatcher> ignorePaths;
    private final AntPathRequestMatcher completed = new AntPathRequestMatcher("/force_password_change_completed");
    private final RequestCache cache;

    public PasswordChangeRequiredFilter(String redirectUri, RequestCache cache, String ... ignoreUris) {
        this.redirectUri = redirectUri;
        this.matcher = new AntPathRequestMatcher(redirectUri);
        this.cache = cache;
        this.ignorePaths = new LinkedList<AntPathRequestMatcher>();
        if (ignoreUris != null) {
            for (String s : ignoreUris) {
                this.ignorePaths.add(new AntPathRequestMatcher(s));
            }
        }
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.isIgnored(request, response)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else if (this.isCompleted(request)) {
            this.logger.debug((Object)"Forced password change has been completed.");
            SavedRequest savedRequest = this.cache.getRequest(request, response);
            if (savedRequest != null) {
                this.sendRedirect(savedRequest.getRedirectUrl(), request, response);
            } else {
                this.sendRedirect("/", request, response);
            }
        } else if (this.needsPasswordReset() && !this.matcher.matches(request)) {
            this.logger.debug((Object)"Password change is required for user.");
            this.cache.saveRequest(request, response);
            this.sendRedirect(this.redirectUri, request, response);
        } else if (this.matcher.matches(request) && this.isAuthenticated() && !this.needsPasswordReset()) {
            this.sendRedirect("/", request, response);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected boolean isIgnored(HttpServletRequest request, HttpServletResponse response) {
        for (AntPathRequestMatcher matcher : this.ignorePaths) {
            if (!matcher.matches(request)) continue;
            return true;
        }
        return false;
    }

    private boolean isAuthenticated() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && authentication.isAuthenticated();
    }

    protected boolean isCompleted(HttpServletRequest request) {
        UaaAuthentication uaa;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && authentication instanceof UaaAuthentication && (uaa = (UaaAuthentication)authentication).isAuthenticated() && !uaa.isRequiresPasswordChange() && this.completed.matches(request);
    }

    protected void sendRedirect(String redirectUrl, HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuilder url = new StringBuilder(redirectUrl.startsWith("/") ? request.getContextPath() : "");
        url.append(redirectUrl);
        String location = url.toString();
        this.logger.debug((Object)("Redirecting request to " + location));
        response.sendRedirect(location);
    }

    protected boolean needsPasswordReset() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && authentication instanceof UaaAuthentication && ((UaaAuthentication)authentication).isRequiresPasswordChange() && authentication.isAuthenticated();
    }
}

