/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.event;

import org.cloudfoundry.identity.uaa.audit.AuditEvent;
import org.cloudfoundry.identity.uaa.audit.AuditEventType;
import org.cloudfoundry.identity.uaa.authentication.event.AbstractUaaAuthenticationEvent;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public class MfaAuthenticationFailureEvent
extends AbstractUaaAuthenticationEvent {
    private final UaaUser user;
    private final String type;

    public MfaAuthenticationFailureEvent(UaaUser user, Authentication authentication, String type) {
        super(authentication);
        this.user = user;
        this.type = type;
    }

    @Override
    public AuditEvent getAuditEvent() {
        Assert.notNull((Object)this.user, (String)"UaaUser cannot be null");
        return this.createAuditRecord(this.user.getId(), AuditEventType.MfaAuthenticationFailure, this.getOrigin(this.getAuthenticationDetails()) + ", type=" + this.type, this.user.getUsername());
    }

    public UaaUser getUser() {
        return this.user;
    }
}

