/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.mfa;

import javax.servlet.http.HttpSession;
import org.cloudfoundry.identity.uaa.mfa.UserGoogleMfaCredentials;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class MfaCredentialsSessionCache {
    private static final String SESSION_CREDENTIAL_ATTR_NAME = "SESSION_USER_GOOGLE_MFA_CREDENTIALS";

    public UserGoogleMfaCredentials getCredentials() {
        return (UserGoogleMfaCredentials)this.session().getAttribute(SESSION_CREDENTIAL_ATTR_NAME);
    }

    public void putCredentials(UserGoogleMfaCredentials creds) {
        this.session().setAttribute(SESSION_CREDENTIAL_ATTR_NAME, (Object)creds);
    }

    public void removeCredentials() {
        this.session().removeAttribute(SESSION_CREDENTIAL_ATTR_NAME);
    }

    private HttpSession session() {
        HttpSession session = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getSession(false);
        if (session == null) {
            throw new RuntimeException("Session not found");
        }
        return session;
    }
}

