/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.oauth;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.login.AccountSavingAuthenticationSuccessHandler;
import org.cloudfoundry.identity.uaa.provider.oauth.XOAuthAuthenticationManager;
import org.cloudfoundry.identity.uaa.provider.oauth.XOAuthCodeToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;

public class XOAuthAuthenticationFilter
implements Filter {
    private static Log logger = LogFactory.getLog(XOAuthAuthenticationFilter.class);
    private final XOAuthAuthenticationManager xOAuthAuthenticationManager;
    private final AccountSavingAuthenticationSuccessHandler successHandler;

    public XOAuthAuthenticationFilter(XOAuthAuthenticationManager xOAuthAuthenticationManager, AccountSavingAuthenticationSuccessHandler successHandler) {
        this.xOAuthAuthenticationManager = xOAuthAuthenticationManager;
        this.successHandler = successHandler;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (this.containsCredentials(request)) {
            if (this.authenticationWasSuccessful(request, response)) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            request.getRequestDispatcher("/login_implicit").forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public boolean containsCredentials(HttpServletRequest request) {
        String code = request.getParameter("code");
        String idToken = request.getParameter("id_token");
        String accessToken = request.getParameter("access_token");
        String signedRequest = request.getParameter("signed_request");
        return StringUtils.hasText((String)code) || StringUtils.hasText((String)idToken) || StringUtils.hasText((String)accessToken) || StringUtils.hasText((String)signedRequest);
    }

    public boolean authenticationWasSuccessful(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String origin = URIUtil.getName((String)request.getServletPath());
        String code = request.getParameter("code");
        String idToken = request.getParameter("id_token");
        String accessToken = request.getParameter("access_token");
        String signedRequest = request.getParameter("signed_request");
        String redirectUrl = request.getRequestURL().toString();
        XOAuthCodeToken codeToken = new XOAuthCodeToken(code, origin, redirectUrl, idToken, accessToken, signedRequest, new UaaAuthenticationDetails(request));
        try {
            Authentication authentication = this.xOAuthAuthenticationManager.authenticate(codeToken);
            SecurityContextHolder.getContext().setAuthentication(authentication);
            Optional.ofNullable(this.successHandler).ifPresent(handler -> handler.setSavedAccountOptionCookie(request, response, authentication));
        }
        catch (Exception ex) {
            logger.error((Object)"XOauth Authentication exception", (Throwable)ex);
            String message = ex.getMessage();
            if (!StringUtils.hasText((String)message)) {
                message = ex.getClass().getSimpleName();
            }
            String errorMessage = URLEncoder.encode("There was an error when authenticating against the external identity provider: " + message, "UTF-8");
            response.sendRedirect(request.getContextPath() + "/oauth_error?error=" + errorMessage);
            return false;
        }
        return true;
    }

    public void destroy() {
    }
}

