/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public abstract class UaaHttpRequestUtils {
    private static Log logger = LogFactory.getLog(UaaHttpRequestUtils.class);

    public static ClientHttpRequestFactory createRequestFactory() {
        return UaaHttpRequestUtils.createRequestFactory(false);
    }

    public static ClientHttpRequestFactory createRequestFactory(boolean skipSslValidation) {
        return UaaHttpRequestUtils.createRequestFactory(UaaHttpRequestUtils.getClientBuilder(skipSslValidation));
    }

    protected static ClientHttpRequestFactory createRequestFactory(HttpClientBuilder builder) {
        return new HttpComponentsClientHttpRequestFactory((HttpClient)builder.build());
    }

    protected static HttpClientBuilder getClientBuilder(boolean skipSslValidation) {
        HttpClientBuilder builder = HttpClients.custom().useSystemProperties().setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy());
        if (skipSslValidation) {
            builder.setSslcontext(UaaHttpRequestUtils.getNonValidatingSslContext());
            builder.setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
        }
        builder.setConnectionReuseStrategy((ConnectionReuseStrategy)NoConnectionReuseStrategy.INSTANCE);
        return builder;
    }

    private static SSLContext getNonValidatingSslContext() {
        try {
            return new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static String paramsToQueryString(Map<String, String[]> parameterMap) {
        return parameterMap.entrySet().stream().flatMap(param -> Arrays.stream((Object[])param.getValue()).map(value -> (String)param.getKey() + "=" + UaaHttpRequestUtils.encodeParameter(value))).collect(Collectors.joining("&"));
    }

    private static String encodeParameter(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isAcceptedInvitationAuthentication() {
        try {
            Boolean result;
            RequestAttributes attr = RequestContextHolder.currentRequestAttributes();
            if (attr != null && (result = (Boolean)attr.getAttribute("IS_INVITE_ACCEPTANCE", 1)) != null) {
                return result;
            }
        }
        catch (IllegalStateException x) {
            logger.debug((Object)"Unable to retrieve request attributes looking for invitation.");
        }
        return false;
    }
}

