/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.mfa;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.event.MfaAuthenticationFailureEvent;
import org.cloudfoundry.identity.uaa.authentication.event.MfaAuthenticationSuccessEvent;
import org.cloudfoundry.identity.uaa.authentication.event.UserAuthenticationFailureEvent;
import org.cloudfoundry.identity.uaa.mfa.MfaProvider;
import org.cloudfoundry.identity.uaa.mfa.MfaProviderProvisioning;
import org.cloudfoundry.identity.uaa.mfa.UserGoogleMfaCredentials;
import org.cloudfoundry.identity.uaa.mfa.UserGoogleMfaCredentialsProvisioning;
import org.cloudfoundry.identity.uaa.mfa.exception.InvalidMfaCodeException;
import org.cloudfoundry.identity.uaa.mfa.exception.MissingMfaCodeException;
import org.cloudfoundry.identity.uaa.mfa.exception.UserMfaConfigDoesNotExistException;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.ProviderNotFoundException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class StatelessMfaAuthenticationFilter
extends OncePerRequestFilter
implements ApplicationEventPublisherAware {
    private final UserGoogleMfaCredentialsProvisioning provisioning;
    private final Set<String> supportedGrantTypes;
    private final MfaProviderProvisioning mfaProvider;
    private final UaaUserDatabase userDb;
    private ApplicationEventPublisher publisher;

    public StatelessMfaAuthenticationFilter(UserGoogleMfaCredentialsProvisioning provisioning, Set<String> supportedGrantTypes, MfaProviderProvisioning mfaProvider, UaaUserDatabase userDb) {
        this.provisioning = provisioning;
        this.supportedGrantTypes = supportedGrantTypes;
        this.mfaProvider = mfaProvider;
        this.userDb = userDb;
    }

    public boolean isGrantTypeSupported(String type) {
        return this.supportedGrantTypes.contains(type);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        MfaProvider provider = null;
        try {
            if (this.isGrantTypeSupported(request.getParameter("grant_type"))) {
                provider = this.checkMfaCode(request);
                UaaUser user = this.getUaaUser();
                if (provider != null) {
                    this.publishEvent(new MfaAuthenticationSuccessEvent(user, this.getAuthentication(), provider.getType().toValue()));
                }
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (InsufficientAuthenticationException x) {
            this.handleException(new JsonError(400, "invalid_request", x.getMessage()), response);
        }
        catch (MissingMfaCodeException | UserMfaConfigDoesNotExistException e) {
            UaaUser user = this.getUaaUser();
            this.publishEvent(new MfaAuthenticationFailureEvent(user, this.getAuthentication(), provider != null ? provider.getType().toValue() : "null"));
            this.publishEvent(new UserAuthenticationFailureEvent(user, (Authentication)this.getAuthentication()));
            this.handleException(new JsonError(400, "invalid_request", ((Throwable)e).getMessage()), response);
        }
        catch (InvalidMfaCodeException e) {
            UaaUser user = this.getUaaUser();
            this.publishEvent(new MfaAuthenticationFailureEvent(user, this.getAuthentication(), provider != null ? provider.getType().toValue() : "null"));
            this.publishEvent(new UserAuthenticationFailureEvent(user, (Authentication)this.getAuthentication()));
            this.handleException(new JsonError(401, "unauthorized", "Bad credentials"), response);
        }
    }

    protected void handleException(JsonError error, HttpServletResponse response) throws IOException {
        response.setStatus(error.getStatus());
        response.setHeader("Content-Type", "application/json");
        response.getWriter().write(JsonUtils.writeValueAsString((Object)error));
    }

    protected MfaProvider checkMfaCode(HttpServletRequest request) throws ServletException, IOException {
        IdentityZone zone = IdentityZoneHolder.get();
        MfaProvider provider = null;
        UaaAuthentication authentication = this.getAuthentication();
        if (this.isMfaEnabled(zone)) {
            try {
                provider = this.mfaProvider.retrieveByName(zone.getConfig().getMfaConfig().getProviderName(), zone.getId());
            }
            catch (EmptyResultDataAccessException x) {
                throw new ProviderNotFoundException("Unable to find MFA provider for zone:" + zone.getSubdomain());
            }
            Integer code = this.getMfaCode(request);
            UserGoogleMfaCredentials credentials = this.provisioning.getUserGoogleMfaCredentials(authentication.getPrincipal().getId(), provider.getId());
            if (credentials == null) {
                throw new UserMfaConfigDoesNotExistException("User must register a multi-factor authentication token");
            }
            if (!this.provisioning.isValidCode(credentials, code)) {
                throw new InvalidMfaCodeException("Invalid multi-factor authentication code");
            }
            HashSet<String> authMethods = new HashSet<String>(authentication.getAuthenticationMethods());
            authMethods.add("otp");
            authMethods.add("mfa");
            authentication.setAuthenticationMethods(authMethods);
        }
        return provider;
    }

    private void publishEvent(ApplicationEvent event) {
        if (this.publisher != null) {
            this.publisher.publishEvent(event);
        }
    }

    private Integer getMfaCode(HttpServletRequest request) {
        String code = request.getParameter("mfaCode");
        if (StringUtils.isEmpty((Object)code)) {
            throw new MissingMfaCodeException("A multi-factor authentication code is required to complete the request");
        }
        try {
            return Integer.valueOf(code);
        }
        catch (NumberFormatException x) {
            throw new InvalidMfaCodeException("Bad credentials");
        }
    }

    private boolean isMfaEnabled(IdentityZone zone) {
        return zone.getConfig().getMfaConfig().isEnabled();
    }

    private UaaUser getUaaUser() {
        return this.userDb.retrieveUserById(this.getAuthentication().getPrincipal().getId());
    }

    private UaaAuthentication getAuthentication() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null) {
            throw new InsufficientAuthenticationException("User authentication missing");
        }
        if (!(auth instanceof OAuth2Authentication)) {
            throw new InsufficientAuthenticationException("Unrecognizable authentication");
        }
        Authentication userAuth = ((OAuth2Authentication)auth).getUserAuthentication();
        if (!(userAuth instanceof UaaAuthentication)) {
            throw new InsufficientAuthenticationException("Unrecognizable user authentication");
        }
        return (UaaAuthentication)userAuth;
    }

    public Set<String> getSupportedGrantTypes() {
        return Collections.unmodifiableSet(this.supportedGrantTypes);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    public static class JsonError {
        private final int status;
        private final String error;
        private final String error_description;

        private JsonError(int status, String error, String error_description) {
            this.status = status;
            this.error = error;
            this.error_description = error_description;
        }

        public String getError() {
            return this.error;
        }

        public String getError_description() {
            return this.error_description;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

