/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.account;

import java.security.Principal;
import org.cloudfoundry.identity.uaa.account.UserInfoResponse;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.user.UserInfo;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.expression.OAuth2ExpressionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class UserInfoEndpoint
implements InitializingBean {
    private UaaUserDatabase userDatabase;

    public void setUserDatabase(UaaUserDatabase userDatabase) {
        this.userDatabase = userDatabase;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.userDatabase != null ? 1 : 0) != 0, (String)"A user database must be provided");
    }

    @RequestMapping(value={"/userinfo"})
    @ResponseBody
    public UserInfoResponse loginInfo(Principal principal) {
        OAuth2Authentication authentication = (OAuth2Authentication)principal;
        UaaPrincipal uaaPrincipal = this.extractUaaPrincipal(authentication);
        boolean addCustomAttributes = OAuth2ExpressionUtils.hasAnyScope((Authentication)authentication, (String[])new String[]{"user_attributes"});
        boolean addRoles = OAuth2ExpressionUtils.hasAnyScope((Authentication)authentication, (String[])new String[]{"roles"});
        return this.getResponse(uaaPrincipal, addCustomAttributes, addRoles);
    }

    protected UaaPrincipal extractUaaPrincipal(OAuth2Authentication authentication) {
        Object object = authentication.getUserAuthentication().getPrincipal();
        if (object instanceof UaaPrincipal) {
            return (UaaPrincipal)object;
        }
        throw new IllegalStateException("User authentication could not be converted to UaaPrincipal");
    }

    protected UserInfoResponse getResponse(UaaPrincipal principal, boolean addCustomAttributes, boolean addRoles) {
        UaaUser user = this.userDatabase.retrieveUserById(principal.getId());
        UserInfoResponse response = new UserInfoResponse();
        response.setUserId(user.getId());
        response.setUserName(user.getUsername());
        response.setGivenName(user.getGivenName());
        response.setFamilyName(user.getFamilyName());
        response.setEmail(user.getEmail());
        response.setEmailVerified(user.isVerified());
        response.setPhoneNumber(user.getPhoneNumber());
        response.setPreviousLogonSuccess(user.getPreviousLogonTime());
        UserInfo info = this.userDatabase.getUserInfo(user.getId());
        if (addCustomAttributes && info != null) {
            response.setUserAttributes(info.getUserAttributes());
        }
        if (addRoles && info != null) {
            response.setRoles(info.getRoles());
        }
        return response;
    }
}

