/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.flywaydb.core.internal.util.StringUtils;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.springframework.security.saml.context.SAMLContextProvider;
import org.springframework.security.saml.context.SAMLMessageContext;

public class RedirectSavingSamlContextProvider
implements SAMLContextProvider {
    private final SAMLContextProvider contextProviderDelegate;

    public RedirectSavingSamlContextProvider(SAMLContextProvider contextProviderDelegate) {
        this.contextProviderDelegate = contextProviderDelegate;
    }

    public SAMLMessageContext getLocalEntity(HttpServletRequest request, HttpServletResponse response) throws MetadataProviderException {
        SAMLMessageContext context = this.contextProviderDelegate.getLocalEntity(request, response);
        return RedirectSavingSamlContextProvider.setRelayState(request, context);
    }

    public SAMLMessageContext getLocalAndPeerEntity(HttpServletRequest request, HttpServletResponse response) throws MetadataProviderException {
        SAMLMessageContext context = this.contextProviderDelegate.getLocalAndPeerEntity(request, response);
        return RedirectSavingSamlContextProvider.setRelayState(request, context);
    }

    private static SAMLMessageContext setRelayState(HttpServletRequest request, SAMLMessageContext context) {
        String clientId;
        HashMap<String, String> params = new HashMap<String, String>();
        String redirectUri = request.getParameter("redirect");
        if (StringUtils.hasText((String)redirectUri)) {
            params.put("redirect", redirectUri);
        }
        if (StringUtils.hasText((String)(clientId = request.getParameter("client_id")))) {
            params.put("client_id", clientId);
        }
        context.setRelayState(JsonUtils.writeValueAsString(params));
        return context;
    }
}

