/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.home;

import java.net.URISyntaxException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.client.ClientMetadata;
import org.cloudfoundry.identity.uaa.client.JdbcClientMetadataProvisioning;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneConfiguration;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.cloudfoundry.identity.uaa.zone.Links;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class HomeController {
    private final Log logger = LogFactory.getLog(this.getClass());
    protected final Environment environment;
    private String baseUrl;
    private Links globalLinks;
    @Autowired
    private JdbcClientMetadataProvisioning clientMetadataProvisioning;

    public HomeController(Environment environment) {
        this.environment = environment;
    }

    public Links getGlobalLinks() {
        return this.globalLinks;
    }

    public void setGlobalLinks(Links globalLinks) {
        this.globalLinks = globalLinks;
    }

    public void setUaaBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    protected String getUaaBaseUrl() {
        return this.baseUrl;
    }

    protected void populateBuildAndLinkInfo(Model model) {
        HashMap attributes = new HashMap();
        model.addAllAttributes(attributes);
    }

    @RequestMapping(value={"/", "/home"})
    public String home(Model model, Principal principal) {
        String homePage;
        IdentityZoneConfiguration config = IdentityZoneHolder.get().getConfig();
        String string = config != null && config.getLinks().getHomeRedirect() != null ? config.getLinks().getHomeRedirect() : (homePage = this.getGlobalLinks() != null && this.getGlobalLinks().getHomeRedirect() != null ? this.getGlobalLinks().getHomeRedirect() : null);
        if (homePage != null && !"/".equals(homePage) && !"/home".equals(homePage)) {
            homePage = UaaStringUtils.replaceZoneVariables((String)homePage, (IdentityZone)IdentityZoneHolder.get());
            return "redirect:" + homePage;
        }
        model.addAttribute("principal", (Object)principal);
        ArrayList tiles = new ArrayList();
        List<ClientMetadata> clientMetadataList = this.clientMetadataProvisioning.retrieveAll(IdentityZoneHolder.get().getId());
        clientMetadataList.stream().filter(this::shouldShowClient).map(this::tileDataForClient).forEach(tiles::add);
        model.addAttribute("tiles", tiles);
        this.populateBuildAndLinkInfo(model);
        return "home";
    }

    private TileData tileDataForClient(ClientMetadata clientMetadata) {
        String clientName = StringUtils.hasText((String)clientMetadata.getClientName()) ? clientMetadata.getClientName() : clientMetadata.getClientId();
        return new TileData(clientMetadata.getClientId(), clientMetadata.getAppLaunchUrl().toString(), "data:image/png;base64," + clientMetadata.getAppIcon(), clientName);
    }

    private boolean shouldShowClient(ClientMetadata clientMetadata) {
        return clientMetadata.isShowOnHomePage() && clientMetadata.getAppLaunchUrl() != null;
    }

    @RequestMapping(value={"/error500"})
    public String error500(Model model, HttpServletRequest request) {
        this.logger.error((Object)"Internal error", (Throwable)request.getAttribute("javax.servlet.error.exception"));
        this.populateBuildAndLinkInfo(model);
        return "error";
    }

    @RequestMapping(value={"/error", "/error404"})
    public String errorGeneric(Model model) {
        this.populateBuildAndLinkInfo(model);
        return "error";
    }

    @RequestMapping(value={"/saml_error"})
    public String error401(Model model, HttpServletRequest request) {
        AuthenticationException exception = (AuthenticationException)request.getSession().getAttribute("SPRING_SECURITY_LAST_EXCEPTION");
        model.addAttribute("saml_error", (Object)exception.getMessage());
        return "external_auth_error";
    }

    @RequestMapping(value={"/oauth_error"})
    public String error_oauth() throws URISyntaxException {
        return "external_auth_error";
    }

    private static class TileData {
        private String appLaunchUrl;
        private String appIcon;
        private String clientId;
        private String clientName;

        private TileData(String clientId, String appLaunchUrl, String appIcon, String clientName) {
            this.appLaunchUrl = appLaunchUrl;
            this.appIcon = appIcon;
            this.clientId = clientId;
            this.clientName = clientName;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getAppIcon() {
            return this.appIcon;
        }

        public String getAppLaunchUrl() {
            return this.appLaunchUrl;
        }

        public String getClientName() {
            return this.clientName;
        }
    }
}

