/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.util.Date;
import java.util.Optional;
import org.cloudfoundry.identity.uaa.oauth.ClientTokenValidity;
import org.joda.time.DateTime;

public class TokenValidityResolver {
    public static final int DEFAULT_TO_GLOBAL_POLICY = -1;
    private int globalTokenValiditySeconds;
    private ClientTokenValidity clientTokenValidity;

    public TokenValidityResolver(ClientTokenValidity clientTokenValidity, int globalTokenValiditySeconds) {
        this.clientTokenValidity = clientTokenValidity;
        this.globalTokenValiditySeconds = globalTokenValiditySeconds;
    }

    public Date resolve(String clientId) {
        Integer tokenValiditySeconds = Optional.ofNullable(this.clientTokenValidity.getValiditySeconds(clientId)).orElse(this.clientTokenValidity.getZoneValiditySeconds());
        if (tokenValiditySeconds == -1) {
            tokenValiditySeconds = this.globalTokenValiditySeconds;
        }
        return DateTime.now().plusSeconds(tokenValiditySeconds.intValue()).toDate();
    }
}

