/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.audit.AuditEventType;
import org.cloudfoundry.identity.uaa.audit.event.AbstractUaaEvent;
import org.cloudfoundry.identity.uaa.audit.event.SystemDeletable;
import org.cloudfoundry.identity.uaa.resources.jdbc.AbstractQueryable;
import org.cloudfoundry.identity.uaa.resources.jdbc.JdbcPagingListFactory;
import org.cloudfoundry.identity.uaa.resources.jdbc.SimpleSearchQueryConverter;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidScimResourceException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceAlreadyExistsException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceConstraintFailedException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.cloudfoundry.identity.uaa.scim.jdbc.JdbcScimGroupExternalMembershipManager;
import org.cloudfoundry.identity.uaa.scim.jdbc.JdbcScimGroupMembershipManager;
import org.cloudfoundry.identity.uaa.scim.jdbc.ScimGroupRowMapper;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.ZoneManagementScopes;
import org.cloudfoundry.identity.uaa.zone.event.IdentityZoneModifiedEvent;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcScimGroupProvisioning
extends AbstractQueryable<ScimGroup>
implements ScimGroupProvisioning,
SystemDeletable {
    private JdbcScimGroupExternalMembershipManager externalGroupMappingManager;
    private JdbcTemplate jdbcTemplate;
    private JdbcScimGroupMembershipManager membershipManager;
    private final Log logger = LogFactory.getLog(this.getClass());
    public static final String GROUP_FIELDS = "id,displayName,description,created,lastModified,version,identity_zone_id";
    public static final String GROUP_TABLE = "groups";
    public static final String GROUP_MEMBERSHIP_TABLE = "group_membership";
    public static final String EXTERNAL_GROUP_TABLE = "external_group_mapping";
    public static final String ADD_GROUP_SQL = String.format("insert into %s ( %s ) values (?,?,?,?,?,?,?)", "groups", "id,displayName,description,created,lastModified,version,identity_zone_id");
    public static final String UPDATE_GROUP_SQL = String.format("update %s set version=?, displayName=?, description=?, lastModified=? where id=? and version=? and identity_zone_id=?", "groups");
    public static final String GET_GROUP_SQL = String.format("select %s from %s where id=? and identity_zone_id=?", "id,displayName,description,created,lastModified,version,identity_zone_id", "groups");
    public static final String GET_GROUP_BY_NAME_SQL = String.format("select %s from %s where displayName=? and identity_zone_id=?", "id,displayName,description,created,lastModified,version,identity_zone_id", "groups");
    public static final String QUERY_FOR_FILTER = String.format("select %s from %s", "id,displayName,description,created,lastModified,version,identity_zone_id", "groups");
    public static final String DELETE_GROUP_SQL = String.format("delete from %s where id=? and identity_zone_id=?", "groups");
    public static final String DELETE_GROUP_BY_ZONE = String.format("delete from %s where identity_zone_id=?", "groups");
    public static final String DELETE_GROUP_MEMBERSHIP_BY_ZONE = String.format("delete from %s where identity_zone_id = ?", "group_membership");
    public static final String DELETE_EXTERNAL_GROUP_BY_ZONE = String.format("delete from %s where identity_zone_id = ?", "external_group_mapping");
    public static final String DELETE_ZONE_ADMIN_MEMBERSHIP_BY_ZONE = String.format("delete from %s where group_id in (select id from %s where identity_zone_id=? and displayName like ?)", "group_membership", "groups");
    public static final String DELETE_ZONE_ADMIN_GROUPS_BY_ZONE = String.format("delete from %s where identity_zone_id=? and displayName like ?", "groups");
    public static final String DELETE_GROUP_MEMBERSHIP_BY_PROVIDER = String.format("delete from %s where identity_zone_id = ? and origin = ?", "group_membership");
    public static final String DELETE_EXTERNAL_GROUP_BY_PROVIDER = String.format("delete from %s where identity_zone_id = ? and origin = ?", "external_group_mapping", "groups");
    public static final String DELETE_MEMBER_SQL = String.format("delete from %s where member_id=? and member_id in (select id from users where id=? and identity_zone_id=?)", "group_membership");
    private final RowMapper<ScimGroup> rowMapper = new ScimGroupRowMapper();

    @Override
    public Log getLogger() {
        return this.logger;
    }

    public JdbcScimGroupProvisioning(JdbcTemplate jdbcTemplate, JdbcPagingListFactory pagingListFactory) {
        super(jdbcTemplate, pagingListFactory, new ScimGroupRowMapper());
        this.membershipManager = new JdbcScimGroupMembershipManager(jdbcTemplate);
        this.membershipManager.setScimGroupProvisioning(this);
        this.externalGroupMappingManager = new JdbcScimGroupExternalMembershipManager(jdbcTemplate);
        this.externalGroupMappingManager.setScimGroupProvisioning(this);
        Assert.notNull((Object)jdbcTemplate);
        this.jdbcTemplate = jdbcTemplate;
        this.setQueryConverter(new SimpleSearchQueryConverter());
    }

    public void createAndIgnoreDuplicate(String name, String zoneId) {
        try {
            this.create(new ScimGroup(null, name, zoneId), zoneId);
        }
        catch (ScimResourceAlreadyExistsException scimResourceAlreadyExistsException) {
            // empty catch block
        }
    }

    @Override
    public ScimGroup createOrGet(ScimGroup group, String zoneId) {
        try {
            return this.getByName(group.getDisplayName(), zoneId);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            this.createAndIgnoreDuplicate(group.getDisplayName(), zoneId);
            return this.getByName(group.getDisplayName(), zoneId);
        }
    }

    @Override
    public ScimGroup getByName(String displayName, String zoneId) {
        if (!StringUtils.hasText((String)displayName)) {
            throw new IncorrectResultSizeDataAccessException("group name must contain text", 1, 0);
        }
        List groups = this.jdbcTemplate.query(GET_GROUP_BY_NAME_SQL, this.rowMapper, new Object[]{displayName, zoneId});
        if (groups.size() == 1) {
            return (ScimGroup)groups.get(0);
        }
        throw new IncorrectResultSizeDataAccessException("Invalid result size found for:" + displayName, 1, groups.size());
    }

    @Override
    public void onApplicationEvent(AbstractUaaEvent event) {
        IdentityZoneModifiedEvent zevent;
        if (event != null && event instanceof IdentityZoneModifiedEvent && (zevent = (IdentityZoneModifiedEvent)event).getEventType() == AuditEventType.IdentityZoneCreatedEvent) {
            String zoneId = ((IdentityZone)event.getSource()).getId();
            ZoneManagementScopes.getSystemScopes().stream().forEach(scope -> this.createAndIgnoreDuplicate((String)scope, zoneId));
        }
        SystemDeletable.super.onApplicationEvent(event);
    }

    @Override
    protected String getBaseSqlQuery() {
        return QUERY_FOR_FILTER;
    }

    @Override
    protected String getTableName() {
        return GROUP_TABLE;
    }

    @Override
    public List<ScimGroup> retrieveAll(String zoneId) {
        return this.query("id pr", "created", true, zoneId);
    }

    @Override
    public ScimGroup retrieve(String id, String zoneId) throws ScimResourceNotFoundException {
        try {
            ScimGroup group = (ScimGroup)this.jdbcTemplate.queryForObject(GET_GROUP_SQL, this.rowMapper, new Object[]{id, zoneId});
            return group;
        }
        catch (EmptyResultDataAccessException e) {
            throw new ScimResourceNotFoundException("Group " + id + " does not exist");
        }
    }

    @Override
    public ScimGroup create(final ScimGroup group, final String zoneId) throws InvalidScimResourceException {
        final String id = UUID.randomUUID().toString();
        this.logger.debug((Object)("creating new group with id: " + id));
        try {
            this.validateGroup(group);
            this.jdbcTemplate.update(ADD_GROUP_SQL, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    int pos = 1;
                    ps.setString(pos++, id);
                    ps.setString(pos++, group.getDisplayName());
                    ps.setString(pos++, group.getDescription());
                    ps.setTimestamp(pos++, new Timestamp(new Date().getTime()));
                    ps.setTimestamp(pos++, new Timestamp(new Date().getTime()));
                    ps.setInt(pos++, group.getVersion());
                    ps.setString(pos++, zoneId);
                }
            });
        }
        catch (DuplicateKeyException ex) {
            throw new ScimResourceAlreadyExistsException("A group with displayName: " + group.getDisplayName() + " already exists.");
        }
        return this.retrieve(id, zoneId);
    }

    @Override
    public ScimGroup update(final String id, final ScimGroup group, final String zoneId) throws InvalidScimResourceException, ScimResourceNotFoundException {
        try {
            this.validateGroup(group);
            int updated = this.jdbcTemplate.update(UPDATE_GROUP_SQL, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    int pos = 1;
                    ps.setInt(pos++, group.getVersion() + 1);
                    ps.setString(pos++, group.getDisplayName());
                    ps.setString(pos++, group.getDescription());
                    ps.setTimestamp(pos++, new Timestamp(new Date().getTime()));
                    ps.setString(pos++, id);
                    ps.setInt(pos++, group.getVersion());
                    ps.setString(pos++, zoneId);
                }
            });
            if (updated != 1) {
                throw new IncorrectResultSizeDataAccessException(1, updated);
            }
            return this.retrieve(id, zoneId);
        }
        catch (DuplicateKeyException ex) {
            throw new InvalidScimResourceException("A group with displayName: " + group.getDisplayName() + " already exists");
        }
    }

    @Override
    public ScimGroup delete(String id, int version, String zoneId) throws ScimResourceNotFoundException {
        ScimGroup group = this.retrieve(id, zoneId);
        this.membershipManager.removeMembersByGroupId(id, zoneId);
        this.externalGroupMappingManager.unmapAll(id, zoneId);
        int deleted = version > 0 ? this.jdbcTemplate.update(DELETE_GROUP_SQL + " and version=?;", new Object[]{id, zoneId, version}) : this.jdbcTemplate.update(DELETE_GROUP_SQL, new Object[]{id, zoneId});
        if (deleted != 1) {
            throw new IncorrectResultSizeDataAccessException(1, deleted);
        }
        return group;
    }

    @Override
    public int deleteByIdentityZone(String zoneId) {
        this.jdbcTemplate.update(DELETE_ZONE_ADMIN_MEMBERSHIP_BY_ZONE, new Object[]{IdentityZone.getUaa().getId(), "zones." + zoneId + ".%"});
        this.jdbcTemplate.update(DELETE_ZONE_ADMIN_GROUPS_BY_ZONE, new Object[]{IdentityZone.getUaa().getId(), "zones." + zoneId + ".%"});
        this.jdbcTemplate.update(DELETE_EXTERNAL_GROUP_BY_ZONE, new Object[]{zoneId});
        this.jdbcTemplate.update(DELETE_GROUP_MEMBERSHIP_BY_ZONE, new Object[]{zoneId});
        return this.jdbcTemplate.update(DELETE_GROUP_BY_ZONE, new Object[]{zoneId});
    }

    @Override
    public int deleteByOrigin(String origin, String zoneId) {
        this.jdbcTemplate.update(DELETE_EXTERNAL_GROUP_BY_PROVIDER, new Object[]{zoneId, origin});
        return this.jdbcTemplate.update(DELETE_GROUP_MEMBERSHIP_BY_PROVIDER, new Object[]{zoneId, origin});
    }

    @Override
    public int deleteByUser(String userId, String zoneId) {
        int result = this.jdbcTemplate.update(DELETE_MEMBER_SQL, new Object[]{userId, userId, zoneId});
        return result;
    }

    protected void validateGroup(ScimGroup group) throws ScimResourceConstraintFailedException {
        if (!StringUtils.hasText((String)group.getZoneId())) {
            throw new ScimResourceConstraintFailedException("zoneId is a required field");
        }
    }

    @Override
    protected void validateOrderBy(String orderBy) throws IllegalArgumentException {
        super.validateOrderBy(orderBy, GROUP_FIELDS);
    }
}

