/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.implicit.ImplicitTokenRequest;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.util.Assert;

public class HybridTokenGranterForAuthorizationCode
extends AbstractTokenGranter {
    private static final String GRANT_TYPE = "authorization_code";

    public HybridTokenGranterForAuthorizationCode(AuthorizationServerTokenServices tokenServices, ClientServicesExtension clientDetailsService, OAuth2RequestFactory requestFactory) {
        super(tokenServices, (ClientDetailsService)clientDetailsService, requestFactory, GRANT_TYPE);
    }

    protected OAuth2Authentication getOAuth2Authentication(ClientDetails client, TokenRequest clientToken) {
        Authentication userAuth = SecurityContextHolder.getContext().getAuthentication();
        if (userAuth == null || !userAuth.isAuthenticated()) {
            throw new InsufficientAuthenticationException("There is no currently logged in user");
        }
        Assert.state((boolean)(clientToken instanceof ImplicitTokenRequest), (String)"An ImplicitTokenRequest is required here. Caller needs to wrap the TokenRequest.");
        OAuth2Request requestForStorage = ((ImplicitTokenRequest)clientToken).getOAuth2Request();
        return new OAuth2Authentication(requestForStorage, userAuth);
    }
}

