/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.openid;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class IdToken {
    public final String sub;
    public final List<String> aud;
    public final String iss;
    public final Date exp;
    public final Date iat;
    @JsonIgnore
    public final Date authTime;
    public final Set<String> amr;
    public final Set<String> acr;
    public final String azp;
    @JsonProperty(value="given_name")
    public final String givenName;
    @JsonProperty(value="family_name")
    public final String familyName;
    @JsonProperty(value="previous_logon_time")
    public final Long previousLogonTime;
    @JsonProperty(value="phone_number")
    public final String phoneNumber;
    public final Set<String> roles;
    @JsonProperty(value="user_attributes")
    public final Map<String, List<String>> userAttributes;
    public final List<String> scope = ImmutableList.of((Object)"openid");
    @JsonProperty(value="email_verified")
    public final Boolean emailVerified;
    public final String nonce;
    public final String email;
    @JsonProperty(value="cid")
    public final String clientId;
    @JsonProperty(value="grant_type")
    public final String grantType;
    @JsonProperty(value="user_name")
    public final String userName;
    public final String zid;
    public final String origin;
    public final String jti;
    @JsonProperty(value="rev_sig")
    public final String revSig;

    public IdToken(String sub, List<String> aud, String iss, Date exp, Date iat, Date authTime, Set<String> amr, Set<String> acr, String azp, String givenName, String familyName, Long previousLogonTime, String phoneNumber, Set<String> roles, Map<String, List<String>> userAttributes, Boolean emailVerified, String nonce, String email, String clientId, String grantType, String userName, String zid, String origin, String jti, String revSig) {
        this.sub = sub;
        this.aud = aud;
        this.iss = iss;
        this.exp = exp;
        this.iat = iat;
        this.authTime = authTime;
        this.amr = amr;
        this.acr = acr;
        this.azp = azp;
        this.givenName = givenName;
        this.familyName = familyName;
        this.previousLogonTime = previousLogonTime;
        this.phoneNumber = phoneNumber;
        this.roles = roles;
        this.userAttributes = userAttributes;
        this.emailVerified = emailVerified;
        this.nonce = nonce;
        this.email = email;
        this.clientId = clientId;
        this.grantType = grantType;
        this.userName = userName;
        this.zid = zid;
        this.origin = origin;
        this.jti = jti;
        this.revSig = revSig;
    }

    @JsonProperty(value="acr")
    public Map<String, Set<String>> getAcr() {
        if (this.acr == null) {
            return null;
        }
        HashMap<String, Set<String>> acrMap = new HashMap<String, Set<String>>();
        acrMap.put("values", this.acr);
        return acrMap;
    }

    @JsonProperty(value="client_id")
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="exp")
    public Long getExpInSeconds() {
        return this.exp.getTime() / 1000L;
    }

    @JsonProperty(value="iat")
    public Long getIatInSeconds() {
        return this.iat.getTime() / 1000L;
    }

    @JsonProperty(value="auth_time")
    public Long getAuthTimeInSeconds() {
        if (this.authTime == null) {
            return null;
        }
        return this.authTime.getTime() / 1000L;
    }

    @JsonProperty(value="user_id")
    public String userId() {
        return this.sub;
    }
}

