/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.openid;

import com.google.common.collect.Lists;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.oauth.TokenValidityResolver;
import org.cloudfoundry.identity.uaa.oauth.openid.IdToken;
import org.cloudfoundry.identity.uaa.oauth.openid.IdTokenCreationException;
import org.cloudfoundry.identity.uaa.oauth.openid.UserAuthenticationData;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.util.UaaTokenUtils;
import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.joda.time.DateTime;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.provider.ClientDetails;

public class IdTokenCreator {
    private final Log logger = LogFactory.getLog(this.getClass());
    private String issuerUrlBase;
    private TokenValidityResolver tokenValidityResolver;
    private UaaUserDatabase uaaUserDatabase;
    private ClientServicesExtension clientServicesExtension;
    private Set<String> excludedClaims;

    public IdTokenCreator(String issuerUrlBase, TokenValidityResolver tokenValidityResolver, UaaUserDatabase uaaUserDatabase, ClientServicesExtension clientServicesExtension, Set<String> excludedClaims) {
        this.tokenValidityResolver = tokenValidityResolver;
        this.uaaUserDatabase = uaaUserDatabase;
        this.clientServicesExtension = clientServicesExtension;
        this.excludedClaims = excludedClaims;
        this.issuerUrlBase = issuerUrlBase;
    }

    public IdToken create(String clientId, String userId, UserAuthenticationData userAuthenticationData) throws IdTokenCreationException {
        String issuerUrl;
        UaaUser uaaUser;
        Date expiryDate = this.tokenValidityResolver.resolve(clientId);
        Date issuedAt = DateTime.now().toDate();
        try {
            uaaUser = this.uaaUserDatabase.retrieveUserById(userId);
        }
        catch (UsernameNotFoundException e) {
            this.logger.error((Object)("Could not create ID token for unknown user " + userId), (Throwable)e);
            throw new IdTokenCreationException();
        }
        Set<String> roles = this.buildRoles(userAuthenticationData);
        Map<String, List<String>> userAttributes = this.buildUserAttributes(userAuthenticationData);
        String givenName = this.getIfScopeContainsProfile(uaaUser.getGivenName(), userAuthenticationData.scopes);
        String familyName = this.getIfScopeContainsProfile(uaaUser.getFamilyName(), userAuthenticationData.scopes);
        String phoneNumber = this.getIfScopeContainsProfile(uaaUser.getPhoneNumber(), userAuthenticationData.scopes);
        try {
            issuerUrl = UaaTokenUtils.constructTokenEndpointUrl(this.issuerUrlBase);
        }
        catch (URISyntaxException e) {
            this.logger.error((Object)"Could not construct the issuer url", (Throwable)e);
            throw new IdTokenCreationException();
        }
        String identityZone = IdentityZoneHolder.get().getId();
        ClientDetails clientDetails = this.clientServicesExtension.loadClientByClientId(clientId, identityZone);
        String clientTokenSalt = (String)clientDetails.getAdditionalInformation().get("token_salt");
        String revSig = UaaTokenUtils.getRevocableTokenSignature(uaaUser, clientTokenSalt, clientId, clientDetails.getClientSecret());
        return new IdToken(this.getIfNotExcluded(userId, "user_id"), this.getIfNotExcluded(Lists.newArrayList((Object[])new String[]{clientId}), "aud"), this.getIfNotExcluded(issuerUrl, "iss"), this.getIfNotExcluded(expiryDate, "exp"), this.getIfNotExcluded(issuedAt, "iat"), this.getIfNotExcluded(userAuthenticationData.time, "auth_time"), this.getIfNotExcluded(userAuthenticationData.methods, "amr"), this.getIfNotExcluded(userAuthenticationData.contextClassRef, "acr"), this.getIfNotExcluded(clientId, "azp"), this.getIfNotExcluded(givenName, "given_name"), this.getIfNotExcluded(familyName, "family_name"), this.getIfNotExcluded(uaaUser.getPreviousLogonTime(), "previous_logon_time"), this.getIfNotExcluded(phoneNumber, "phone_number"), this.getIfNotExcluded(roles, "roles"), this.getIfNotExcluded(userAttributes, "user_attributes"), this.getIfNotExcluded(uaaUser.isVerified(), "email_verified"), this.getIfNotExcluded(userAuthenticationData.nonce, "nonce"), this.getIfNotExcluded(uaaUser.getEmail(), "email"), this.getIfNotExcluded(clientId, "cid"), this.getIfNotExcluded(userAuthenticationData.grantType, "grant_type"), this.getIfNotExcluded(uaaUser.getUsername(), "user_name"), this.getIfNotExcluded(identityZone, "zid"), this.getIfNotExcluded(uaaUser.getOrigin(), "origin"), this.getIfNotExcluded(userAuthenticationData.jti, "jti"), this.getIfNotExcluded(revSig, "rev_sig"));
    }

    private String getIfScopeContainsProfile(String value, Set<String> scopes) {
        return scopes.contains("profile") ? value : null;
    }

    private <T> T getIfNotExcluded(T value, String excludedKey) {
        return this.excludedClaims.contains(excludedKey) ? null : (T)value;
    }

    private Map<String, List<String>> buildUserAttributes(UserAuthenticationData userAuthenticationData) {
        if (!userAuthenticationData.scopes.contains("user_attributes")) {
            return null;
        }
        return userAuthenticationData.userAttributes;
    }

    private Set<String> buildRoles(UserAuthenticationData userAuthenticationData) {
        if (!userAuthenticationData.scopes.contains("roles") || userAuthenticationData.roles == null || userAuthenticationData.roles.isEmpty()) {
            return null;
        }
        return userAuthenticationData.roles;
    }
}

