/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.UaaIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.scim.InternalUserManagementDisabledException;
import org.cloudfoundry.identity.uaa.util.ObjectUtils;
import org.cloudfoundry.identity.uaa.web.ExceptionReport;
import org.cloudfoundry.identity.uaa.web.ExceptionReportHttpMessageConverter;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.NestedServletException;

public class DisableUserManagementSecurityFilter
extends OncePerRequestFilter {
    public static final String INTERNAL_USER_CREATION_IS_CURRENTLY_DISABLED = "Internal User Creation is currently disabled. External User Store is in use.";
    private final IdentityProviderProvisioning identityProviderProvisioning;
    private static String regex1 = "";
    private Pattern pattern1 = Pattern.compile(regex1);
    private List<String> methods1 = Arrays.asList("GET", "POST", "PUT", "DELETE");

    public DisableUserManagementSecurityFilter(IdentityProviderProvisioning identityProviderProvisioning) {
        this.identityProviderProvisioning = identityProviderProvisioning;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            if (this.matches(request)) {
                IdentityProvider idp = this.identityProviderProvisioning.retrieveByOrigin("uaa", IdentityZoneHolder.get().getId());
                boolean isDisableInternalUserManagement = false;
                UaaIdentityProviderDefinition config = (UaaIdentityProviderDefinition)ObjectUtils.castInstance((Object)idp.getConfig(), UaaIdentityProviderDefinition.class);
                if (config != null) {
                    isDisableInternalUserManagement = config.isDisableInternalUserManagement();
                }
                if (isDisableInternalUserManagement) {
                    throw new InternalUserManagementDisabledException(INTERNAL_USER_CREATION_IS_CURRENTLY_DISABLED);
                }
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (InternalUserManagementDisabledException x) {
            this.handleInternalUserManagementDisabledException(response, x);
        }
        catch (NestedServletException x) {
            if (x.getRootCause() instanceof InternalUserManagementDisabledException) {
                this.handleInternalUserManagementDisabledException(response, (InternalUserManagementDisabledException)x.getRootCause());
            }
            throw x;
        }
    }

    private void handleInternalUserManagementDisabledException(HttpServletResponse response, InternalUserManagementDisabledException x) throws IOException {
        ExceptionReportHttpMessageConverter converter = new ExceptionReportHttpMessageConverter();
        response.setStatus(403);
        converter.write(new ExceptionReport(x), MediaType.APPLICATION_JSON, (HttpOutputMessage)new ServletServerHttpResponse(response));
    }

    private boolean matches(HttpServletRequest request) {
        return this.pattern1.matcher(this.getUri(request)).matches() && this.methods1.contains(request.getMethod());
    }

    private String getUri(HttpServletRequest request) {
        if (request.getContextPath() != null && request.getContextPath().length() > 0) {
            return request.getServletPath();
        }
        return request.getRequestURI();
    }

    static {
        regex1 = "^/Users/.*/password";
        regex1 = regex1 + "|^/Users/.*/verify";
        regex1 = regex1 + "|^/create_account";
        regex1 = regex1 + "|^/create_account.do";
        regex1 = regex1 + "|^/accounts/email_sent";
        regex1 = regex1 + "|^/verify_user";
        regex1 = regex1 + "|^/change_email";
        regex1 = regex1 + "|^/change_email.do";
        regex1 = regex1 + "|^/verify_email";
        regex1 = regex1 + "|^/change_password";
        regex1 = regex1 + "|^/change_password.do";
        regex1 = regex1 + "|^/forgot_password";
        regex1 = regex1 + "|^/forgot_password.do";
        regex1 = regex1 + "|^/email_sent";
        regex1 = regex1 + "|^/reset_password";
        regex1 = regex1 + "|^/reset_password.do";
    }
}

