/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.audit.event.SystemDeletable;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneConfiguration;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneProvisioning;
import org.cloudfoundry.identity.uaa.zone.ZoneAlreadyExistsException;
import org.cloudfoundry.identity.uaa.zone.ZoneDoesNotExistsException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcIdentityZoneProvisioning
implements IdentityZoneProvisioning,
SystemDeletable {
    public static final String ID_ZONE_FIELDS = "id,version,created,lastmodified,name,subdomain,description,config";
    public static final String ID_ZONE_UPDATE_FIELDS = "version,lastmodified,name,subdomain,description,config".replace(",", "=?,") + "=?";
    public static final String CREATE_IDENTITY_ZONE_SQL = "insert into identity_zone(id,version,created,lastmodified,name,subdomain,description,config) values (?,?,?,?,?,?,?,?)";
    public static final String UPDATE_IDENTITY_ZONE_SQL = "update identity_zone set " + ID_ZONE_UPDATE_FIELDS + " where id=?";
    public static final String DELETE_IDENTITY_ZONE_SQL = "delete from identity_zone where id=?";
    public static final String IDENTITY_ZONES_QUERY = "select id,version,created,lastmodified,name,subdomain,description,config from identity_zone ";
    public static final String IDENTITY_ZONE_BY_ID_QUERY = "select id,version,created,lastmodified,name,subdomain,description,config from identity_zone where id=?";
    public static final String IDENTITY_ZONE_BY_SUBDOMAIN_QUERY = "select id,version,created,lastmodified,name,subdomain,description,config from identity_zone where subdomain=?";
    public static final Log logger = LogFactory.getLog(JdbcIdentityZoneProvisioning.class);
    protected final JdbcTemplate jdbcTemplate;
    private final RowMapper<IdentityZone> mapper = new IdentityZoneRowMapper();

    public JdbcIdentityZoneProvisioning(JdbcTemplate jdbcTemplate) {
        Assert.notNull((Object)jdbcTemplate);
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public IdentityZone retrieve(String id) {
        try {
            IdentityZone identityZone = (IdentityZone)this.jdbcTemplate.queryForObject(IDENTITY_ZONE_BY_ID_QUERY, this.mapper, new Object[]{id});
            return identityZone;
        }
        catch (EmptyResultDataAccessException x) {
            throw new ZoneDoesNotExistsException("Zone[" + id + "] not found.", x);
        }
    }

    @Override
    public List<IdentityZone> retrieveAll() {
        return this.jdbcTemplate.query(IDENTITY_ZONES_QUERY, this.mapper);
    }

    @Override
    public IdentityZone retrieveBySubdomain(String subdomain) {
        if (subdomain == null) {
            throw new EmptyResultDataAccessException("Subdomain cannot be null", 1);
        }
        IdentityZone identityZone = (IdentityZone)this.jdbcTemplate.queryForObject(IDENTITY_ZONE_BY_SUBDOMAIN_QUERY, this.mapper, new Object[]{subdomain.toLowerCase()});
        return identityZone;
    }

    @Override
    public IdentityZone create(final IdentityZone identityZone) {
        try {
            this.jdbcTemplate.update(CREATE_IDENTITY_ZONE_SQL, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setString(1, identityZone.getId().trim());
                    ps.setInt(2, identityZone.getVersion());
                    ps.setTimestamp(3, new Timestamp(new Date().getTime()));
                    ps.setTimestamp(4, new Timestamp(new Date().getTime()));
                    ps.setString(5, identityZone.getName());
                    ps.setString(6, identityZone.getSubdomain().toLowerCase());
                    ps.setString(7, identityZone.getDescription());
                    ps.setString(8, identityZone.getConfig() != null ? JsonUtils.writeValueAsString((Object)identityZone.getConfig()) : null);
                }
            });
        }
        catch (DuplicateKeyException e) {
            throw new ZoneAlreadyExistsException(e.getMostSpecificCause().getMessage(), e);
        }
        return this.retrieve(identityZone.getId());
    }

    @Override
    public IdentityZone update(final IdentityZone identityZone) {
        try {
            this.jdbcTemplate.update(UPDATE_IDENTITY_ZONE_SQL, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setInt(1, identityZone.getVersion() + 1);
                    ps.setTimestamp(2, new Timestamp(new Date().getTime()));
                    ps.setString(3, identityZone.getName());
                    ps.setString(4, identityZone.getSubdomain().toLowerCase());
                    ps.setString(5, identityZone.getDescription());
                    ps.setString(6, identityZone.getConfig() != null ? JsonUtils.writeValueAsString((Object)identityZone.getConfig()) : null);
                    ps.setString(7, identityZone.getId().trim());
                }
            });
        }
        catch (DuplicateKeyException e) {
            throw new ZoneAlreadyExistsException(e.getMostSpecificCause().getMessage(), e);
        }
        return this.retrieve(identityZone.getId());
    }

    @Override
    public int deleteByIdentityZone(String zoneId) {
        return this.jdbcTemplate.update(DELETE_IDENTITY_ZONE_SQL, new Object[]{zoneId});
    }

    @Override
    public Log getLogger() {
        return logger;
    }

    public static final class IdentityZoneRowMapper
    implements RowMapper<IdentityZone> {
        public IdentityZone mapRow(ResultSet rs, int rowNum) throws SQLException {
            IdentityZone identityZone = new IdentityZone();
            identityZone.setId(rs.getString(1).trim());
            identityZone.setVersion(rs.getInt(2));
            identityZone.setCreated((Date)rs.getTimestamp(3));
            identityZone.setLastModified((Date)rs.getTimestamp(4));
            identityZone.setName(rs.getString(5));
            identityZone.setSubdomain(rs.getString(6));
            identityZone.setDescription(rs.getString(7));
            String config = rs.getString(8);
            if (StringUtils.hasText((String)config)) {
                try {
                    identityZone.setConfig((IdentityZoneConfiguration)JsonUtils.readValue((String)config, IdentityZoneConfiguration.class));
                }
                catch (JsonUtils.JsonUtilException e) {
                    logger.error((Object)("Invalid zone configuration found for zone id:" + identityZone.getId()), (Throwable)e);
                    identityZone.setConfig(new IdentityZoneConfiguration());
                }
            }
            return identityZone;
        }
    }
}

