/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.PasswordChangeRequiredException;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.provider.oauth.XOAuthAuthenticationManager;
import org.cloudfoundry.identity.uaa.provider.oauth.XOAuthCodeToken;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.error.OAuth2AuthenticationEntryPoint;
import org.springframework.security.saml.SAMLProcessingFilter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;

public class BackwardsCompatibleTokenEndpointAuthenticationFilter
implements Filter {
    private static final Log logger = LogFactory.getLog(BackwardsCompatibleTokenEndpointAuthenticationFilter.class);
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private AuthenticationEntryPoint authenticationEntryPoint = new OAuth2AuthenticationEntryPoint();
    private final AuthenticationManager authenticationManager;
    private final OAuth2RequestFactory oAuth2RequestFactory;
    private final SAMLProcessingFilter samlAuthenticationFilter;
    private final XOAuthAuthenticationManager xoAuthAuthenticationManager;

    public BackwardsCompatibleTokenEndpointAuthenticationFilter(AuthenticationManager authenticationManager, OAuth2RequestFactory oAuth2RequestFactory) {
        this(authenticationManager, oAuth2RequestFactory, null, null);
    }

    public BackwardsCompatibleTokenEndpointAuthenticationFilter(AuthenticationManager authenticationManager, OAuth2RequestFactory oAuth2RequestFactory, SAMLProcessingFilter samlAuthenticationFilter, XOAuthAuthenticationManager xoAuthAuthenticationManager) {
        this.authenticationManager = authenticationManager;
        this.oAuth2RequestFactory = oAuth2RequestFactory;
        this.samlAuthenticationFilter = samlAuthenticationFilter;
        this.xoAuthAuthenticationManager = xoAuthAuthenticationManager;
    }

    public void setAuthenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            Authentication userAuthentication = this.attemptTokenAuthentication(request, response);
            if (userAuthentication != null) {
                Authentication clientAuth = SecurityContextHolder.getContext().getAuthentication();
                if (clientAuth == null) {
                    throw new BadCredentialsException("No client authentication found. Remember to put a filter upstream of the TokenEndpointAuthenticationFilter.");
                }
                Map<String, String> map = this.getSingleValueMap(request);
                map.put("client_id", clientAuth.getName());
                SecurityContextHolder.getContext().setAuthentication(userAuthentication);
                AuthorizationRequest authorizationRequest = this.oAuth2RequestFactory.createAuthorizationRequest(map);
                if (clientAuth.isAuthenticated()) {
                    authorizationRequest.setApproved(true);
                }
                OAuth2Request storedOAuth2Request = this.oAuth2RequestFactory.createOAuth2Request(authorizationRequest);
                SecurityContextHolder.getContext().setAuthentication((Authentication)new OAuth2Authentication(storedOAuth2Request, userAuthentication));
                this.onSuccessfulAuthentication(request, response, userAuthentication);
            }
        }
        catch (AuthenticationException failed) {
            logger.debug((Object)("Authentication request failed: " + failed.getMessage()));
            this.onUnsuccessfulAuthentication(request, response, failed);
            this.authenticationEntryPoint.commence(request, response, failed);
            return;
        }
        catch (OAuth2Exception failed) {
            String message = failed.getMessage();
            logger.debug((Object)("Authentication request failed with Oauth exception: " + message));
            InsufficientAuthenticationException ex = new InsufficientAuthenticationException(message, (Throwable)failed);
            this.onUnsuccessfulAuthentication(request, response, (AuthenticationException)ex);
            this.authenticationEntryPoint.commence(request, response, (AuthenticationException)ex);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private Map<String, String> getSingleValueMap(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Map parameters = request.getParameterMap();
        Iterator iterator = parameters.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String[] values = (String[])parameters.get(key = (String)iterator.next());
            map.put(key, values != null && values.length > 0 ? values[0] : null);
        }
        return map;
    }

    protected void onSuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
    }

    protected void onUnsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException {
        SecurityContextHolder.clearContext();
    }

    protected Authentication extractCredentials(HttpServletRequest request) {
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        UsernamePasswordAuthenticationToken credentials = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        credentials.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        return credentials;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Authentication attemptTokenAuthentication(HttpServletRequest request, HttpServletResponse response) {
        Authentication authResult;
        block9: {
            String grantType = request.getParameter("grant_type");
            logger.debug((Object)("Processing token user authentication for grant:" + grantType));
            authResult = null;
            if ("password".equals(grantType)) {
                UaaAuthentication uaaAuthentication;
                Authentication credentials = this.extractCredentials(request);
                logger.debug((Object)("Authentication credentials found password grant for '" + credentials.getName() + "'"));
                authResult = this.authenticationManager.authenticate(credentials);
                if (authResult != null && authResult.isAuthenticated() && authResult instanceof UaaAuthentication && (uaaAuthentication = (UaaAuthentication)authResult).isRequiresPasswordChange()) {
                    throw new PasswordChangeRequiredException(uaaAuthentication, "password change required");
                }
                return authResult;
            }
            if ("urn:ietf:params:oauth:grant-type:saml2-bearer".equals(grantType)) {
                logger.debug((Object)"urn:ietf:params:oauth:grant-type:saml2-bearer found. Attempting authentication with assertion");
                String assertion = request.getParameter("assertion");
                if (assertion != null && this.samlAuthenticationFilter != null) {
                    logger.debug((Object)"Attempting SAML authentication for token endpoint.");
                    authResult = this.samlAuthenticationFilter.attemptAuthentication(request, response);
                    break block9;
                } else {
                    logger.debug((Object)"No assertion or filter, not attempting SAML authentication for token endpoint.");
                    throw new InsufficientAuthenticationException("SAML Assertion is missing");
                }
            }
            if ("urn:ietf:params:oauth:grant-type:jwt-bearer".equals(grantType)) {
                logger.debug((Object)"urn:ietf:params:oauth:grant-type:jwt-bearer found. Attempting authentication with assertion");
                String assertion = request.getParameter("assertion");
                if (assertion != null && this.xoAuthAuthenticationManager != null) {
                    logger.debug((Object)"Attempting OIDC JWT authentication for token endpoint.");
                    XOAuthCodeToken token = new XOAuthCodeToken(null, null, null, assertion, null, null);
                    token.setRequestContextPath(this.getContextPath(request));
                    authResult = this.xoAuthAuthenticationManager.authenticate(token);
                } else {
                    logger.debug((Object)"No assertion or authentication manager, not attempting JWT bearer authentication for token endpoint.");
                    throw new InsufficientAuthenticationException("Assertion is missing");
                }
            }
        }
        if (authResult != null && authResult.isAuthenticated()) {
            logger.debug((Object)("Authentication success: " + authResult.getName()));
            return authResult;
        }
        return null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    private String getContextPath(HttpServletRequest request) {
        StringBuffer requestURL = request.getRequestURL();
        return requestURL.substring(0, requestURL.length() - request.getServletPath().length());
    }
}

