/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.error.ParameterParsingException;
import org.cloudfoundry.identity.uaa.error.UaaException;
import org.cloudfoundry.identity.uaa.oauth.jwt.Jwt;
import org.cloudfoundry.identity.uaa.oauth.jwt.JwtHelper;
import org.cloudfoundry.identity.uaa.oauth.token.Claims;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.error.DefaultWebResponseExceptionTranslator;
import org.springframework.security.oauth2.provider.error.WebResponseExceptionTranslator;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class CheckTokenEndpoint
implements InitializingBean {
    private static final String PARAMETER_PARSE_FAILED_ATTR = "org.apache.catalina.parameter_parse_failed";
    private ResourceServerTokenServices resourceServerTokenServices;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private WebResponseExceptionTranslator exceptionTranslator = new DefaultWebResponseExceptionTranslator();
    private Boolean allowQueryString = null;

    public void setTokenServices(ResourceServerTokenServices resourceServerTokenServices) {
        this.resourceServerTokenServices = resourceServerTokenServices;
    }

    public boolean isAllowQueryString() {
        return this.allowQueryString == null ? true : this.allowQueryString;
    }

    public void setAllowQueryString(boolean allowQueryString) {
        this.allowQueryString = allowQueryString;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.resourceServerTokenServices, (String)"tokenServices must be set");
    }

    @RequestMapping(value={"/check_token"}, method={RequestMethod.POST})
    @ResponseBody
    public Claims checkToken(@RequestParam(value="token") String value, @RequestParam(name="scopes", required=false, defaultValue="") List<String> scopes, HttpServletRequest request) throws HttpRequestMethodNotSupportedException {
        if (!this.hadParsedAllArgs(request)) {
            throw new ParameterParsingException();
        }
        if (StringUtils.hasText((String)request.getQueryString()) && !this.isAllowQueryString()) {
            this.logger.debug((Object)"Call to /oauth/check_token contains a query string. Aborting.");
            throw new HttpRequestMethodNotSupportedException("POST");
        }
        OAuth2AccessToken token = this.resourceServerTokenServices.readAccessToken(value);
        if (token == null) {
            throw new InvalidTokenException("Token was not recognised");
        }
        if (token.isExpired()) {
            throw new InvalidTokenException("Token has expired");
        }
        try {
            this.resourceServerTokenServices.loadAuthentication(value);
        }
        catch (AuthenticationException x) {
            throw new InvalidTokenException(x.getMessage());
        }
        Claims response = this.getClaimsForToken(token.getValue());
        List claimScopes = response.getScope().stream().map(String::toLowerCase).collect(Collectors.toList());
        ArrayList<String> missingScopes = new ArrayList<String>();
        for (String expectedScope : scopes) {
            if (claimScopes.contains(expectedScope.toLowerCase())) continue;
            missingScopes.add(expectedScope);
        }
        if (!missingScopes.isEmpty()) {
            throw new InvalidScopeException("Some requested scopes are missing: " + String.join((CharSequence)",", missingScopes));
        }
        return response;
    }

    private boolean hadParsedAllArgs(HttpServletRequest request) {
        return request.getAttribute(PARAMETER_PARSE_FAILED_ATTR) == null;
    }

    @RequestMapping(value={"/check_token"})
    @ResponseBody
    public Claims checkToken(HttpServletRequest request) throws HttpRequestMethodNotSupportedException {
        if (this.isAllowQueryString()) {
            String token = request.getParameter("token");
            String scope = request.getParameter("scope");
            return this.checkToken(token, StringUtils.hasText((String)scope) ? new LinkedList(StringUtils.commaDelimitedListToSet((String)scope)) : Collections.emptyList(), request);
        }
        throw new HttpRequestMethodNotSupportedException(request.getMethod());
    }

    private Claims getClaimsForToken(String token) {
        Claims claims;
        Jwt tokenJwt;
        try {
            tokenJwt = JwtHelper.decode(token);
        }
        catch (Throwable t) {
            throw new InvalidTokenException("Invalid token (could not decode): " + token);
        }
        try {
            claims = (Claims)JsonUtils.readValue((String)tokenJwt.getClaims(), Claims.class);
        }
        catch (JsonUtils.JsonUtilException e) {
            throw new InvalidTokenException("Cannot read token claims", (Throwable)e);
        }
        return claims;
    }

    @ExceptionHandler(value={InvalidTokenException.class})
    public ResponseEntity<OAuth2Exception> handleException(Exception e) throws Exception {
        this.logger.info((Object)("Handling error: " + e.getClass().getSimpleName() + ", " + e.getMessage()));
        InvalidTokenException e400 = new InvalidTokenException(e.getMessage()){

            public int getHttpErrorCode() {
                return 400;
            }
        };
        return this.exceptionTranslator.translate((Exception)((Object)e400));
    }

    @ExceptionHandler(value={InvalidScopeException.class})
    public ResponseEntity<OAuth2Exception> handleInvalidScopeException(Exception e) throws Exception {
        this.logger.info((Object)("Handling error: " + e.getClass().getSimpleName() + ", " + e.getMessage()));
        return this.exceptionTranslator.translate(e);
    }

    @ExceptionHandler(value={UaaException.class})
    public ResponseEntity<UaaException> handleInvalidScopeSTUFF(UaaException e) throws Exception {
        this.logger.info((Object)("Handling error: " + e.getClass().getSimpleName() + ", " + e.getMessage()));
        return new ResponseEntity((Object)e, HttpStatus.valueOf((int)e.getHttpStatus()));
    }
}

