/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.audit.event.SystemDeletable;
import org.cloudfoundry.identity.uaa.resources.ResourceMonitor;
import org.cloudfoundry.identity.uaa.resources.jdbc.AbstractQueryable;
import org.cloudfoundry.identity.uaa.resources.jdbc.JdbcPagingListFactory;
import org.cloudfoundry.identity.uaa.resources.jdbc.SimpleSearchQueryConverter;
import org.cloudfoundry.identity.uaa.scim.ScimMeta;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidPasswordException;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidScimResourceException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceAlreadyExistsException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceConstraintFailedException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.cloudfoundry.identity.uaa.scim.util.ScimUtils;
import org.cloudfoundry.identity.uaa.util.TimeService;
import org.cloudfoundry.identity.uaa.util.TimeServiceImpl;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcScimUserProvisioning
extends AbstractQueryable<ScimUser>
implements ScimUserProvisioning,
ResourceMonitor<ScimUser>,
SystemDeletable {
    private final Log logger = LogFactory.getLog(this.getClass());
    public static final String USER_FIELDS = "id,version,created,lastModified,username,email,givenName,familyName,active,phoneNumber,verified,origin,external_id,identity_zone_id,salt,passwd_lastmodified,last_logon_success_time,previous_logon_success_time";
    public static final String CREATE_USER_SQL = "insert into users (id,version,created,lastModified,username,email,givenName,familyName,active,phoneNumber,verified,origin,external_id,identity_zone_id,salt,passwd_lastmodified,last_logon_success_time,previous_logon_success_time,password) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    public static final String UPDATE_USER_SQL = "update users set version=?, lastModified=?, userName=?, email=?, givenName=?, familyName=?, active=?, phoneNumber=?, verified=?, origin=?, external_id=?, salt=? where id=? and version=? and identity_zone_id=?";
    public static final String DEACTIVATE_USER_SQL = "update users set active=? where id=? and identity_zone_id=?";
    public static final String VERIFY_USER_SQL = "update users set verified=? where id=? and identity_zone_id=?";
    public static final String DELETE_USER_SQL = "delete from users where id=? and identity_zone_id=?";
    public static final String UPDATE_PASSWD_LASTMODIFIED_SQL = "update users set passwd_lastmodified=? where id=? and identity_zone_id=?";
    public static final String CHANGE_PASSWORD_SQL = "update users set lastModified=?, password=?, passwd_lastmodified=? where id=? and identity_zone_id=?";
    public static final String READ_PASSWORD_SQL = "select password from users where id=? and identity_zone_id=?";
    public static final String UPDATE_PASSWORD_CHANGE_REQUIRED_SQL = "update users set passwd_change_required=? where id=? and identity_zone_id=?";
    public static final String UPDATE_LAST_LOGON_TIME_SQL = "update users set previous_logon_success_time = last_logon_success_time, last_logon_success_time = ? where id = ? and identity_zone_id=?";
    public static final String READ_PASSWORD_CHANGE_REQUIRED_SQL = "select passwd_change_required from users where id=? and identity_zone_id=?";
    public static final String USER_BY_ID_QUERY = "select id,version,created,lastModified,username,email,givenName,familyName,active,phoneNumber,verified,origin,external_id,identity_zone_id,salt,passwd_lastmodified,last_logon_success_time,previous_logon_success_time from users where id=? and identity_zone_id=?";
    public static final String ALL_USERS = "select id,version,created,lastModified,username,email,givenName,familyName,active,phoneNumber,verified,origin,external_id,identity_zone_id,salt,passwd_lastmodified,last_logon_success_time,previous_logon_success_time from users";
    public static final String HARD_DELETE_OF_GROUP_MEMBERS_BY_ZONE = "delete from group_membership where identity_zone_id = ?";
    public static final String HARD_DELETE_OF_GROUP_MEMBERS_BY_PROVIDER = "delete from group_membership where identity_zone_id = ? and origin = ?";
    public static final String HARD_DELETE_BY_ZONE = "delete from users where identity_zone_id = ?";
    public static final String HARD_DELETE_BY_PROVIDER = "delete from users where identity_zone_id = ? and origin = ?";
    protected final JdbcTemplate jdbcTemplate;
    private PasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
    private boolean deactivateOnDelete = true;
    private static final RowMapper<ScimUser> mapper = new ScimUserRowMapper();
    private Pattern usernamePattern = Pattern.compile("[\\p{L}+0-9+\\-_.@'!]+");
    private TimeService timeService = new TimeServiceImpl();

    @Override
    public Log getLogger() {
        return this.logger;
    }

    public JdbcScimUserProvisioning(JdbcTemplate jdbcTemplate, JdbcPagingListFactory pagingListFactory) {
        super(jdbcTemplate, pagingListFactory, mapper);
        Assert.notNull((Object)jdbcTemplate);
        this.jdbcTemplate = jdbcTemplate;
        this.setQueryConverter(new SimpleSearchQueryConverter());
    }

    public void setTimeService(TimeService timeService) {
        this.timeService = timeService;
    }

    @Override
    public ScimUser retrieve(String id, String zoneId) {
        try {
            ScimUser u = (ScimUser)this.jdbcTemplate.queryForObject(USER_BY_ID_QUERY, mapper, new Object[]{id, zoneId});
            return u;
        }
        catch (EmptyResultDataAccessException e) {
            throw new ScimResourceNotFoundException("User " + id + " does not exist");
        }
    }

    @Override
    protected String getBaseSqlQuery() {
        return ALL_USERS;
    }

    @Override
    protected String getTableName() {
        return "users";
    }

    @Override
    public List<ScimUser> retrieveAll(String zoneId) {
        return this.query("id pr", "created", true, zoneId);
    }

    @Override
    public ScimUser create(final ScimUser user, String zoneId) {
        if (!StringUtils.hasText((String)user.getOrigin())) {
            user.setOrigin("uaa");
        }
        this.logger.debug((Object)("Creating new user: " + user.getUserName()));
        final String id = UUID.randomUUID().toString();
        final String identityZoneId = zoneId;
        final String origin = user.getOrigin();
        try {
            this.jdbcTemplate.update(CREATE_USER_SQL, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    Timestamp t = new Timestamp(new Date().getTime());
                    ps.setString(1, id);
                    ps.setInt(2, user.getVersion());
                    ps.setTimestamp(3, t);
                    ps.setTimestamp(4, t);
                    ps.setString(5, user.getUserName());
                    ps.setString(6, user.getPrimaryEmail());
                    if (user.getName() == null) {
                        ps.setString(7, null);
                        ps.setString(8, null);
                    } else {
                        ps.setString(7, user.getName().getGivenName());
                        ps.setString(8, user.getName().getFamilyName());
                    }
                    ps.setBoolean(9, user.isActive());
                    String phoneNumber = JdbcScimUserProvisioning.this.extractPhoneNumber(user);
                    ps.setString(10, phoneNumber);
                    ps.setBoolean(11, user.isVerified());
                    ps.setString(12, origin);
                    ps.setString(13, StringUtils.hasText((String)user.getExternalId()) ? user.getExternalId() : null);
                    ps.setString(14, identityZoneId);
                    ps.setString(15, user.getSalt());
                    ps.setTimestamp(16, JdbcScimUserProvisioning.this.getPasswordLastModifiedTimestamp(t));
                    ps.setNull(17, -5);
                    ps.setNull(18, -5);
                    ps.setString(19, user.getPassword());
                }
            });
        }
        catch (DuplicateKeyException e) {
            ScimUser existingUser = (ScimUser)this.query("userName eq \"" + user.getUserName() + "\" and origin eq \"" + (StringUtils.hasText((String)user.getOrigin()) ? user.getOrigin() : "uaa") + "\"", zoneId).get(0);
            HashMap<String, Object> userDetails = new HashMap<String, Object>();
            userDetails.put("active", existingUser.isActive());
            userDetails.put("verified", existingUser.isVerified());
            userDetails.put("user_id", existingUser.getId());
            throw new ScimResourceAlreadyExistsException("Username already in use: " + existingUser.getUserName(), userDetails);
        }
        return this.retrieve(id, zoneId);
    }

    protected Timestamp getPasswordLastModifiedTimestamp(Timestamp t) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(14, 0);
        return new Timestamp(cal.getTimeInMillis());
    }

    @Override
    public ScimUser createUser(ScimUser user, String password, String zoneId) throws InvalidPasswordException, InvalidScimResourceException {
        user.setPassword(this.passwordEncoder.encode((CharSequence)password));
        return this.create(user, zoneId);
    }

    public String extractPhoneNumber(ScimUser user) {
        String phoneNumber = null;
        if (user.getPhoneNumbers() != null && !user.getPhoneNumbers().isEmpty()) {
            phoneNumber = ((ScimUser.PhoneNumber)user.getPhoneNumbers().get(0)).getValue();
        }
        return phoneNumber;
    }

    @Override
    public ScimUser update(final String id, final ScimUser user, final String zoneId) throws InvalidScimResourceException {
        this.logger.debug((Object)("Updating user " + user.getUserName()));
        final String origin = StringUtils.hasText((String)user.getOrigin()) ? user.getOrigin() : "uaa";
        user.setOrigin(origin);
        ScimUtils.validate(user);
        int updated = this.jdbcTemplate.update(UPDATE_USER_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                int pos = 1;
                Timestamp t = new Timestamp(new Date().getTime());
                ps.setInt(pos++, user.getVersion() + 1);
                ps.setTimestamp(pos++, t);
                ps.setString(pos++, user.getUserName());
                ps.setString(pos++, user.getPrimaryEmail());
                ps.setString(pos++, user.getName().getGivenName());
                ps.setString(pos++, user.getName().getFamilyName());
                ps.setBoolean(pos++, user.isActive());
                ps.setString(pos++, JdbcScimUserProvisioning.this.extractPhoneNumber(user));
                ps.setBoolean(pos++, user.isVerified());
                ps.setString(pos++, origin);
                ps.setString(pos++, StringUtils.hasText((String)user.getExternalId()) ? user.getExternalId() : null);
                ps.setString(pos++, user.getSalt());
                ps.setString(pos++, id);
                ps.setInt(pos++, user.getVersion());
                ps.setString(pos++, zoneId);
            }
        });
        ScimUser result = this.retrieve(id, zoneId);
        if (updated == 0) {
            throw new OptimisticLockingFailureException(String.format("Attempt to update a user (%s) with wrong version: expected=%d but found=%d", id, result.getVersion(), user.getVersion()));
        }
        if (updated > 1) {
            throw new IncorrectResultSizeDataAccessException(1);
        }
        return result;
    }

    @Override
    public void changePassword(final String id, String oldPassword, String newPassword, final String zoneId) throws ScimResourceNotFoundException {
        if (oldPassword != null && !this.checkPasswordMatches(id, oldPassword, zoneId)) {
            throw new BadCredentialsException("Old password is incorrect");
        }
        if (this.checkPasswordMatches(id, newPassword, zoneId)) {
            return;
        }
        final String encNewPassword = this.passwordEncoder.encode((CharSequence)newPassword);
        int updated = this.jdbcTemplate.update(CHANGE_PASSWORD_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                Timestamp t = new Timestamp(System.currentTimeMillis());
                ps.setTimestamp(1, t);
                ps.setString(2, encNewPassword);
                ps.setTimestamp(3, JdbcScimUserProvisioning.this.getPasswordLastModifiedTimestamp(t));
                ps.setString(4, id);
                ps.setString(5, zoneId);
            }
        });
        if (updated == 0) {
            throw new ScimResourceNotFoundException("User " + id + " does not exist");
        }
        if (updated != 1) {
            throw new ScimResourceConstraintFailedException("User " + id + " duplicated");
        }
    }

    @Override
    public boolean checkPasswordMatches(String id, String password, String zoneId) {
        String currentPassword;
        try {
            currentPassword = (String)this.jdbcTemplate.queryForObject(READ_PASSWORD_SQL, new Object[]{id, zoneId}, new int[]{12, 12}, String.class);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            throw new ScimResourceNotFoundException("User " + id + " does not exist");
        }
        return this.passwordEncoder.matches((CharSequence)password, currentPassword);
    }

    @Override
    public boolean checkPasswordChangeIndividuallyRequired(String userId, String zoneId) throws ScimResourceNotFoundException {
        return (Boolean)this.jdbcTemplate.queryForObject(READ_PASSWORD_CHANGE_REQUIRED_SQL, Boolean.TYPE, new Object[]{userId, zoneId});
    }

    @Override
    public void updatePasswordChangeRequired(String userId, boolean passwordChangeRequired, String zoneId) throws ScimResourceNotFoundException {
        int updated = this.jdbcTemplate.update(UPDATE_PASSWORD_CHANGE_REQUIRED_SQL, ps -> {
            ps.setBoolean(1, passwordChangeRequired);
            ps.setString(2, userId);
            ps.setString(3, zoneId);
        });
        if (updated == 0) {
            throw new ScimResourceNotFoundException("User " + userId + " does not exist");
        }
    }

    @Override
    public ScimUser delete(String id, int version, String zoneId) {
        ScimUser user = this.retrieve(id, zoneId);
        return this.deactivateOnDelete ? this.deactivateUser(user, version, zoneId) : this.deleteUser(user, version, zoneId);
    }

    private ScimUser deactivateUser(ScimUser user, int version, String zoneId) {
        this.logger.debug((Object)("Deactivating user: " + user.getId()));
        int updated = version < 0 ? this.jdbcTemplate.update(DEACTIVATE_USER_SQL, new Object[]{false, user.getId(), zoneId}) : this.jdbcTemplate.update("update users set active=? where id=? and identity_zone_id=? and version=?", new Object[]{false, user.getId(), zoneId, version});
        if (updated == 0) {
            throw new OptimisticLockingFailureException(String.format("Attempt to update a user (%s) with wrong version: expected=%d but found=%d", user.getId(), user.getVersion(), version));
        }
        if (updated > 1) {
            throw new IncorrectResultSizeDataAccessException(1);
        }
        user.setActive(false);
        return user;
    }

    @Override
    public ScimUser verifyUser(String id, int version, String zoneId) throws ScimResourceNotFoundException, InvalidScimResourceException {
        this.logger.debug((Object)("Verifying user: " + id));
        int updated = version < 0 ? this.jdbcTemplate.update(VERIFY_USER_SQL, new Object[]{true, id, zoneId}) : this.jdbcTemplate.update("update users set verified=? where id=? and identity_zone_id=? and version=?", new Object[]{true, id, zoneId, version});
        ScimUser user = this.retrieve(id, zoneId);
        if (updated == 0) {
            throw new OptimisticLockingFailureException(String.format("Attempt to update a user (%s) with wrong version: expected=%d but found=%d", user.getId(), user.getVersion(), version));
        }
        if (updated > 1) {
            throw new IncorrectResultSizeDataAccessException(1);
        }
        return user;
    }

    protected ScimUser deleteUser(ScimUser user, int version, String zoneId) {
        int updated = this.deleteUser(user.getId(), version, zoneId);
        if (updated == 0) {
            throw new OptimisticLockingFailureException(String.format("Attempt to update a user (%s) with wrong version: expected=%d but found=%d", user.getId(), version, version));
        }
        return user;
    }

    protected int deleteUser(String userId, int version, String zoneId) {
        this.logger.debug((Object)("Deleting user: " + userId));
        int updated = version < 0 ? this.jdbcTemplate.update(DELETE_USER_SQL, new Object[]{userId, zoneId}) : this.jdbcTemplate.update("delete from users where id=? and identity_zone_id=? and version=?", new Object[]{userId, zoneId, version});
        return updated;
    }

    public void setDeactivateOnDelete(boolean deactivateOnDelete) {
        this.deactivateOnDelete = deactivateOnDelete;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        Assert.notNull((Object)passwordEncoder, (String)"passwordEncoder cannot be null");
        this.passwordEncoder = passwordEncoder;
    }

    public void setUsernamePattern(String usernamePattern) {
        Assert.hasText((String)usernamePattern, (String)"Username pattern must not be empty");
        this.usernamePattern = Pattern.compile(usernamePattern);
    }

    @Override
    public int deleteByIdentityZone(String zoneId) {
        this.jdbcTemplate.update(HARD_DELETE_OF_GROUP_MEMBERS_BY_ZONE, new Object[]{zoneId});
        return this.jdbcTemplate.update(HARD_DELETE_BY_ZONE, new Object[]{zoneId});
    }

    @Override
    public int deleteByOrigin(String origin, String zoneId) {
        this.jdbcTemplate.update(HARD_DELETE_OF_GROUP_MEMBERS_BY_PROVIDER, new Object[]{zoneId, origin});
        return this.jdbcTemplate.update(HARD_DELETE_BY_PROVIDER, new Object[]{zoneId, origin});
    }

    @Override
    public int deleteByUser(String userId, String zoneId) {
        this.deleteUser(userId, -1, zoneId);
        return 1;
    }

    @Override
    public int getTotalCount() {
        Integer count = (Integer)this.jdbcTemplate.queryForObject("select count(*) from users", Integer.class);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    protected void validateOrderBy(String orderBy) throws IllegalArgumentException {
        super.validateOrderBy(orderBy, USER_FIELDS);
    }

    @Override
    public void updateLastLogonTime(String id, String zoneId) {
        this.jdbcTemplate.update(UPDATE_LAST_LOGON_TIME_SQL, new Object[]{this.timeService.getCurrentTimeMillis(), id, zoneId});
    }

    private static final class ScimUserRowMapper
    implements RowMapper<ScimUser> {
        private ScimUserRowMapper() {
        }

        public ScimUser mapRow(ResultSet rs, int rowNum) throws SQLException {
            String id = rs.getString("id");
            int version = rs.getInt("version");
            Timestamp created = rs.getTimestamp("created");
            Timestamp lastModified = rs.getTimestamp("lastModified");
            String userName = rs.getString("username");
            String email = rs.getString("email");
            String givenName = rs.getString("givenName");
            String familyName = rs.getString("familyName");
            boolean active = rs.getBoolean("active");
            String phoneNumber = rs.getString("phoneNumber");
            boolean verified = rs.getBoolean("verified");
            String origin = rs.getString("origin");
            String externalId = rs.getString("external_id");
            String zoneId = rs.getString("identity_zone_id");
            String salt = rs.getString("salt");
            Timestamp passwordLastModified = rs.getTimestamp("passwd_lastmodified");
            Long lastLogonTime = (Long)rs.getObject("last_logon_success_time");
            Long previousLogonTime = (Long)rs.getObject("previous_logon_success_time");
            ScimUser user = new ScimUser();
            user.setId(id);
            ScimMeta meta = new ScimMeta();
            meta.setVersion(version);
            meta.setCreated((Date)created);
            meta.setLastModified((Date)lastModified);
            user.setMeta(meta);
            user.setUserName(userName);
            if (StringUtils.hasText((String)email)) {
                user.addEmail(email);
            }
            if (phoneNumber != null) {
                user.addPhoneNumber(phoneNumber);
            }
            ScimUser.Name name = new ScimUser.Name();
            name.setGivenName(givenName);
            name.setFamilyName(familyName);
            user.setName(name);
            user.setActive(active);
            user.setVerified(verified);
            user.setOrigin(origin);
            user.setExternalId(externalId);
            user.setZoneId(zoneId);
            user.setSalt(salt);
            user.setPasswordLastModified((Date)passwordLastModified);
            user.setLastLogonTime(lastLogonTime);
            user.setPreviousLogonTime(previousLogonTime);
            return user;
        }
    }
}

