/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.oauth;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.identity.uaa.provider.AbstractIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.AbstractXOAuthIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderWrapper;
import org.cloudfoundry.identity.uaa.provider.OIDCIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.RawXOAuthIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.util.StringUtils;

public class OauthIDPWrapperFactoryBean {
    private Map<String, AbstractXOAuthIdentityProviderDefinition> oauthIdpDefinitions = new HashMap<String, AbstractXOAuthIdentityProviderDefinition>();
    private List<IdentityProviderWrapper> providers = new LinkedList<IdentityProviderWrapper>();

    public OauthIDPWrapperFactoryBean(Map<String, Map> definitions) {
        if (definitions != null) {
            for (String alias : definitions.keySet()) {
                Map idpDefinitionMap = definitions.get(alias);
                try {
                    RawXOAuthIdentityProviderDefinition rawDef;
                    IdentityProvider provider = new IdentityProvider();
                    String type = (String)idpDefinitionMap.get("type");
                    if ("oauth2.0".equalsIgnoreCase(type)) {
                        RawXOAuthIdentityProviderDefinition oauthIdentityProviderDefinition = new RawXOAuthIdentityProviderDefinition();
                        oauthIdentityProviderDefinition.setCheckTokenUrl(idpDefinitionMap.get("checkTokenUrl") == null ? null : new URL((String)idpDefinitionMap.get("checkTokenUrl")));
                        this.setCommonProperties(idpDefinitionMap, (AbstractXOAuthIdentityProviderDefinition)oauthIdentityProviderDefinition);
                        this.oauthIdpDefinitions.put(alias, (AbstractXOAuthIdentityProviderDefinition)oauthIdentityProviderDefinition);
                        rawDef = oauthIdentityProviderDefinition;
                        provider.setType("oauth2.0");
                    } else if ("oidc1.0".equalsIgnoreCase(type)) {
                        OIDCIdentityProviderDefinition oidcIdentityProviderDefinition = new OIDCIdentityProviderDefinition();
                        this.setCommonProperties(idpDefinitionMap, (AbstractXOAuthIdentityProviderDefinition)oidcIdentityProviderDefinition);
                        oidcIdentityProviderDefinition.setUserInfoUrl(idpDefinitionMap.get("userInfoUrl") == null ? null : new URL((String)idpDefinitionMap.get("userInfoUrl")));
                        this.oauthIdpDefinitions.put(alias, (AbstractXOAuthIdentityProviderDefinition)oidcIdentityProviderDefinition);
                        rawDef = oidcIdentityProviderDefinition;
                        provider.setType("oidc1.0");
                    } else {
                        throw new IllegalArgumentException("Unknown type for provider. Type must be oauth2.0 or oidc1.0. (Was " + type + ")");
                    }
                    boolean override = true;
                    if (idpDefinitionMap.get("override") != null) {
                        override = (Boolean)idpDefinitionMap.get("override");
                    }
                    IdentityProviderWrapper wrapper = OauthIDPWrapperFactoryBean.getIdentityProviderWrapper(alias, (AbstractXOAuthIdentityProviderDefinition)rawDef, provider, override);
                    this.providers.add(wrapper);
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("OAuth/OIDC Provider Configuration - URL is malformed.", e);
                }
            }
        }
    }

    public static IdentityProviderWrapper getIdentityProviderWrapper(String origin, AbstractXOAuthIdentityProviderDefinition rawDef, IdentityProvider provider, boolean override) {
        provider.setOriginKey(origin);
        provider.setName("UAA Oauth Identity Provider[" + provider.getOriginKey() + "]");
        provider.setActive(true);
        try {
            provider.setConfig((AbstractIdentityProviderDefinition)rawDef);
        }
        catch (JsonUtils.JsonUtilException x) {
            throw new RuntimeException("Non serializable Oauth config");
        }
        IdentityProviderWrapper wrapper = new IdentityProviderWrapper(provider);
        wrapper.setOverride(override);
        return wrapper;
    }

    protected void setCommonProperties(Map<String, Object> idpDefinitionMap, AbstractXOAuthIdentityProviderDefinition idpDefinition) {
        idpDefinition.setLinkText((String)idpDefinitionMap.get("linkText"));
        idpDefinition.setRelyingPartyId((String)idpDefinitionMap.get("relyingPartyId"));
        idpDefinition.setRelyingPartySecret((String)idpDefinitionMap.get("relyingPartySecret"));
        idpDefinition.setEmailDomain((List)idpDefinitionMap.get("emailDomain"));
        idpDefinition.setShowLinkText(idpDefinitionMap.get("showLinkText") == null ? true : (Boolean)idpDefinitionMap.get("showLinkText"));
        idpDefinition.setAddShadowUserOnLogin(idpDefinitionMap.get("addShadowUserOnLogin") == null ? true : (Boolean)idpDefinitionMap.get("addShadowUserOnLogin"));
        idpDefinition.setStoreCustomAttributes(idpDefinitionMap.get("storeCustomAttributes") == null ? true : (Boolean)idpDefinitionMap.get("storeCustomAttributes"));
        idpDefinition.setSkipSslValidation(idpDefinitionMap.get("skipSslValidation") == null ? false : (Boolean)idpDefinitionMap.get("skipSslValidation"));
        idpDefinition.setTokenKey((String)idpDefinitionMap.get("tokenKey"));
        idpDefinition.setIssuer((String)idpDefinitionMap.get("issuer"));
        idpDefinition.setAttributeMappings((Map)idpDefinitionMap.get("attributeMappings"));
        idpDefinition.setScopes((List)idpDefinitionMap.get("scopes"));
        String responseType = (String)idpDefinitionMap.get("responseType");
        if (StringUtils.hasText((String)responseType)) {
            idpDefinition.setResponseType(responseType);
        }
        String discoveryUrl = (String)idpDefinitionMap.get("discoveryUrl");
        try {
            if (StringUtils.hasText((String)discoveryUrl) && idpDefinition instanceof OIDCIdentityProviderDefinition) {
                ((OIDCIdentityProviderDefinition)idpDefinition).setDiscoveryUrl(new URL(discoveryUrl));
            } else {
                idpDefinition.setAuthUrl(new URL((String)idpDefinitionMap.get("authUrl")));
                idpDefinition.setTokenKeyUrl(idpDefinitionMap.get("tokenKeyUrl") == null ? null : new URL((String)idpDefinitionMap.get("tokenKeyUrl")));
                idpDefinition.setTokenUrl(new URL((String)idpDefinitionMap.get("tokenUrl")));
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("URL is malformed.", e);
        }
        if (idpDefinitionMap.get("clientAuthInBody") instanceof Boolean) {
            idpDefinition.setClientAuthInBody(((Boolean)idpDefinitionMap.get("clientAuthInBody")).booleanValue());
        }
    }

    public Map<String, AbstractXOAuthIdentityProviderDefinition> getOauthIdpDefinitions() {
        return this.oauthIdpDefinitions;
    }

    public List<IdentityProviderWrapper> getProviders() {
        return this.providers;
    }

    public void setOauthIdpDefinitions(Map<String, AbstractXOAuthIdentityProviderDefinition> oauthIdpDefinitions) {
        this.oauthIdpDefinitions = oauthIdpDefinitions;
    }
}

