/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.jwk;

import com.fasterxml.jackson.core.type.TypeReference;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.cloudfoundry.identity.uaa.oauth.KeyInfo;
import org.cloudfoundry.identity.uaa.oauth.jwk.JsonWebKey;
import org.cloudfoundry.identity.uaa.oauth.jwk.JsonWebKeySet;
import org.cloudfoundry.identity.uaa.util.JsonUtils;

public class JsonWebKeyHelper {
    private static Base64 base64 = new Base64(true);

    public static JsonWebKey fromPEMPrivateKey(String key) {
        KeyPair pair = KeyInfo.parseKeyPair(key);
        RSAPublicKey rsaKey = (RSAPublicKey)pair.getPublic();
        BigInteger modulus = rsaKey.getModulus();
        BigInteger exponent = rsaKey.getPublicExponent();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("n", base64.encodeAsString(modulus.toByteArray()));
        properties.put("e", base64.encodeAsString(exponent.toByteArray()));
        properties.put("kty", "RSA");
        properties.put("use", JsonWebKey.KeyUse.sig.name());
        properties.put("value", KeyInfo.pemEncodePublicKey(rsaKey));
        return new JsonWebKey(properties);
    }

    public static JsonWebKey fromPEMPublicKey(String key) {
        return JsonWebKeyHelper.fromPEMPrivateKey(key);
    }

    public static JsonWebKeySet<JsonWebKey> deserialize(String s) {
        if (!s.contains("\"keys\"")) {
            return new JsonWebKeySet(Arrays.asList((JsonWebKey)JsonUtils.readValue((String)s, JsonWebKey.class)));
        }
        return (JsonWebKeySet)JsonUtils.readValue((String)s, (TypeReference)new TypeReference<JsonWebKeySet<JsonWebKey>>(){});
    }

    public static JsonWebKeySet<JsonWebKey> fromResultMaps(List<Map<String, Object>> resultMaps) {
        return new JsonWebKeySet(resultMaps.stream().map(JsonWebKey::new).collect(Collectors.toList()));
    }
}

