/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;
import org.cloudfoundry.identity.uaa.cache.UrlContentCache;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.SamlIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.saml.ConfigMetadataProvider;
import org.cloudfoundry.identity.uaa.provider.saml.FixedHttpMetaDataProvider;
import org.cloudfoundry.identity.uaa.provider.saml.MetadataFetcher;
import org.cloudfoundry.identity.uaa.util.UaaHttpRequestUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.ParserPool;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class SamlIdentityProviderConfigurator
implements InitializingBean {
    private static Log logger = LogFactory.getLog(SamlIdentityProviderConfigurator.class);
    private HttpClientParams clientParams;
    private BasicParserPool parserPool;
    private IdentityProviderProvisioning providerProvisioning;
    private UrlContentCache contentCache;
    private MetadataFetcher metadataFetcher;
    private Timer dummyTimer = new Timer(){

        @Override
        public void cancel() {
            super.cancel();
        }

        @Override
        public int purge() {
            return 0;
        }

        @Override
        public void schedule(TimerTask task, long delay) {
        }

        @Override
        public void schedule(TimerTask task, long delay, long period) {
        }

        @Override
        public void schedule(TimerTask task, Date firstTime, long period) {
        }

        @Override
        public void schedule(TimerTask task, Date time) {
        }

        @Override
        public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        }

        @Override
        public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        }
    };

    public SamlIdentityProviderConfigurator() {
        this.dummyTimer.cancel();
    }

    public UrlContentCache getContentCache() {
        return this.contentCache;
    }

    public SamlIdentityProviderConfigurator setContentCache(UrlContentCache contentCache) {
        this.contentCache = contentCache;
        return this;
    }

    public List<SamlIdentityProviderDefinition> getIdentityProviderDefinitions() {
        return this.getIdentityProviderDefinitionsForZone(IdentityZoneHolder.get());
    }

    public List<SamlIdentityProviderDefinition> getIdentityProviderDefinitionsForZone(IdentityZone zone) {
        LinkedList<SamlIdentityProviderDefinition> result = new LinkedList<SamlIdentityProviderDefinition>();
        for (IdentityProvider provider : this.providerProvisioning.retrieveActive(zone.getId())) {
            if (!"saml".equals(provider.getType())) continue;
            result.add((SamlIdentityProviderDefinition)provider.getConfig());
        }
        return result;
    }

    public List<SamlIdentityProviderDefinition> getIdentityProviderDefinitions(List<String> allowedIdps, IdentityZone zone) {
        List<SamlIdentityProviderDefinition> idpsInTheZone = this.getIdentityProviderDefinitionsForZone(zone);
        if (allowedIdps != null) {
            LinkedList<SamlIdentityProviderDefinition> result = new LinkedList<SamlIdentityProviderDefinition>();
            for (SamlIdentityProviderDefinition def : idpsInTheZone) {
                if (!allowedIdps.contains(def.getIdpEntityAlias())) continue;
                result.add(def);
            }
            return result;
        }
        return idpsInTheZone;
    }

    public synchronized void validateSamlIdentityProviderDefinition(SamlIdentityProviderDefinition providerDefinition) throws MetadataProviderException {
        Object deleted = null;
        if (providerDefinition == null) {
            throw new NullPointerException();
        }
        if (!StringUtils.hasText((String)providerDefinition.getIdpEntityAlias())) {
            throw new NullPointerException("SAML IDP Alias must be set");
        }
        if (!StringUtils.hasText((String)providerDefinition.getZoneId())) {
            throw new NullPointerException("IDP Zone Id must be set");
        }
        SamlIdentityProviderDefinition clone = providerDefinition.clone();
        ExtendedMetadataDelegate added = this.getExtendedMetadataDelegate(clone);
        String entityIDToBeAdded = ((ConfigMetadataProvider)added.getDelegate()).getEntityID();
        if (!StringUtils.hasText((String)entityIDToBeAdded)) {
            throw new MetadataProviderException("Emtpy entityID for SAML provider with zoneId:" + providerDefinition.getZoneId() + " and origin:" + providerDefinition.getIdpEntityAlias());
        }
        boolean entityIDexists = false;
        for (SamlIdentityProviderDefinition existing : this.getIdentityProviderDefinitions()) {
            ConfigMetadataProvider existingProvider = (ConfigMetadataProvider)this.getExtendedMetadataDelegate(existing).getDelegate();
            if (!entityIDToBeAdded.equals(existingProvider.getEntityID()) || existing.getUniqueAlias().equals(clone.getUniqueAlias())) continue;
            entityIDexists = true;
            break;
        }
        if (entityIDexists) {
            throw new MetadataProviderException("Duplicate entity ID:" + entityIDToBeAdded);
        }
    }

    public synchronized ExtendedMetadataDelegate removeIdentityProviderDefinition(SamlIdentityProviderDefinition providerDefinition) {
        return null;
    }

    public List<ExtendedMetadataDelegate> getSamlIdentityProviders() {
        return this.getSamlIdentityProviders(null);
    }

    public List<ExtendedMetadataDelegate> getSamlIdentityProviders(IdentityZone zone) {
        LinkedList<ExtendedMetadataDelegate> result = new LinkedList<ExtendedMetadataDelegate>();
        for (SamlIdentityProviderDefinition def : this.getIdentityProviderDefinitionsForZone(zone)) {
            try {
                result.add(this.getExtendedMetadataDelegate(def));
            }
            catch (MetadataProviderException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public ExtendedMetadataDelegate getExtendedMetadataDelegateFromCache(SamlIdentityProviderDefinition def) throws MetadataProviderException {
        return this.getExtendedMetadataDelegate(def);
    }

    public ExtendedMetadataDelegate getExtendedMetadataDelegate(SamlIdentityProviderDefinition def) throws MetadataProviderException {
        ExtendedMetadataDelegate metadata;
        switch (def.getType()) {
            case DATA: {
                metadata = this.configureXMLMetadata(def);
                break;
            }
            case URL: {
                metadata = this.configureURLMetadata(def);
                break;
            }
            default: {
                throw new MetadataProviderException("Invalid metadata type for alias[" + def.getIdpEntityAlias() + "]:" + def.getMetaDataLocation());
            }
        }
        return metadata;
    }

    protected ExtendedMetadataDelegate configureXMLMetadata(SamlIdentityProviderDefinition def) {
        ConfigMetadataProvider configMetadataProvider = new ConfigMetadataProvider(def.getZoneId(), def.getIdpEntityAlias(), def.getMetaDataLocation());
        configMetadataProvider.setParserPool((ParserPool)this.getParserPool());
        ExtendedMetadata extendedMetadata = new ExtendedMetadata();
        extendedMetadata.setLocal(false);
        extendedMetadata.setAlias(def.getIdpEntityAlias());
        ExtendedMetadataDelegate delegate = new ExtendedMetadataDelegate((MetadataProvider)configMetadataProvider, extendedMetadata);
        delegate.setMetadataTrustCheck(def.isMetadataTrustCheck());
        return delegate;
    }

    protected FixedHttpMetaDataProvider getFixedHttpMetaDataProvider(SamlIdentityProviderDefinition def, Timer dummyTimer, HttpClientParams params) throws ClassNotFoundException, MetadataProviderException, URISyntaxException, InstantiationException, IllegalAccessException {
        ExtendedMetadata extendedMetadata = new ExtendedMetadata();
        extendedMetadata.setAlias(def.getIdpEntityAlias());
        RestTemplate template = new RestTemplate(UaaHttpRequestUtils.createRequestFactory(def.isSkipSslValidation()));
        FixedHttpMetaDataProvider fixedHttpMetaDataProvider = FixedHttpMetaDataProvider.buildProvider(dummyTimer, this.getClientParams(), this.adjustURIForPort(def.getMetaDataLocation()), template, this.contentCache);
        return fixedHttpMetaDataProvider;
    }

    protected String adjustURIForPort(String uri) throws URISyntaxException {
        URI metadataURI = new URI(uri);
        if (metadataURI.getPort() < 0) {
            switch (metadataURI.getScheme()) {
                case "https": {
                    return new URIBuilder(uri).setPort(443).build().toString();
                }
                case "http": {
                    return new URIBuilder(uri).setPort(80).build().toString();
                }
            }
            return uri;
        }
        return uri;
    }

    protected ExtendedMetadataDelegate configureURLMetadata(SamlIdentityProviderDefinition def) throws MetadataProviderException {
        try {
            def = def.clone();
            ExtendedMetadata extendedMetadata = new ExtendedMetadata();
            extendedMetadata.setAlias(def.getIdpEntityAlias());
            FixedHttpMetaDataProvider fixedHttpMetaDataProvider = this.getFixedHttpMetaDataProvider(def, this.dummyTimer, this.getClientParams());
            byte[] metadata = this.metadataFetcher.fetch(fixedHttpMetaDataProvider);
            def.setMetaDataLocation(new String(metadata, StandardCharsets.UTF_8));
            return this.configureXMLMetadata(def);
        }
        catch (URISyntaxException e) {
            throw new MetadataProviderException("Invalid socket factory(invalid URI):" + def.getMetaDataLocation(), (Exception)e);
        }
        catch (ClassNotFoundException e) {
            throw new MetadataProviderException("Invalid socket factory:" + def.getSocketFactoryClassName(), (Exception)e);
        }
        catch (InstantiationException e) {
            throw new MetadataProviderException("Invalid socket factory:" + def.getSocketFactoryClassName(), (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MetadataProviderException("Invalid socket factory:" + def.getSocketFactoryClassName(), (Exception)e);
        }
    }

    public IdentityProviderProvisioning getIdentityProviderProvisioning() {
        return this.providerProvisioning;
    }

    public void setIdentityProviderProvisioning(IdentityProviderProvisioning providerProvisioning) {
        this.providerProvisioning = providerProvisioning;
    }

    public HttpClientParams getClientParams() {
        return this.clientParams;
    }

    public void setClientParams(HttpClientParams clientParams) {
        this.clientParams = clientParams;
    }

    public BasicParserPool getParserPool() {
        return this.parserPool;
    }

    public void setParserPool(BasicParserPool parserPool) {
        this.parserPool = parserPool;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void setMetadataFetcher(MetadataFetcher metadataFetcher) {
        this.metadataFetcher = metadataFetcher;
    }
}

