/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml.idp;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;
import org.cloudfoundry.identity.uaa.cache.UrlContentCache;
import org.cloudfoundry.identity.uaa.provider.saml.ConfigMetadataProvider;
import org.cloudfoundry.identity.uaa.provider.saml.FixedHttpMetaDataProvider;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProvider;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProviderHolder;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProviderProvisioning;
import org.cloudfoundry.identity.uaa.util.UaaHttpRequestUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.ParserPool;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class SamlServiceProviderConfigurator {
    private static final Log logger = LogFactory.getLog(SamlServiceProviderConfigurator.class);
    private HttpClientParams clientParams;
    private BasicParserPool parserPool;
    private SamlServiceProviderProvisioning providerProvisioning;
    private Set<String> supportedNameIDs = new HashSet<String>(Arrays.asList("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"));
    private UrlContentCache contentCache;
    private Timer dummyTimer = new Timer(){

        @Override
        public void cancel() {
            super.cancel();
        }

        @Override
        public int purge() {
            return 0;
        }

        @Override
        public void schedule(TimerTask task, long delay) {
        }

        @Override
        public void schedule(TimerTask task, long delay, long period) {
        }

        @Override
        public void schedule(TimerTask task, Date firstTime, long period) {
        }

        @Override
        public void schedule(TimerTask task, Date time) {
        }

        @Override
        public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        }

        @Override
        public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        }
    };

    public UrlContentCache getContentCache() {
        return this.contentCache;
    }

    public SamlServiceProviderConfigurator setContentCache(UrlContentCache contentCache) {
        this.contentCache = contentCache;
        return this;
    }

    public SamlServiceProviderConfigurator() {
        this.dummyTimer.cancel();
    }

    public List<SamlServiceProviderHolder> getSamlServiceProviders() {
        return this.getSamlServiceProvidersForZone(IdentityZoneHolder.get());
    }

    public List<SamlServiceProviderHolder> getSamlServiceProvidersForZone(IdentityZone zone) {
        LinkedList<SamlServiceProviderHolder> result = new LinkedList<SamlServiceProviderHolder>();
        for (SamlServiceProvider provider : this.providerProvisioning.retrieveActive(zone.getId())) {
            try {
                SamlServiceProviderHolder samlServiceProviderHolder = new SamlServiceProviderHolder(this.getExtendedMetadataDelegate(provider), provider);
                result.add(samlServiceProviderHolder);
            }
            catch (MetadataProviderException e) {
                logger.error((Object)("Unable to configure SAML SP Metadata for ServiceProvider:" + provider.getEntityId()), (Throwable)e);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public void validateSamlServiceProvider(SamlServiceProvider provider) throws MetadataProviderException {
        this.validateSamlServiceProvider(provider, IdentityZoneHolder.get());
    }

    synchronized void validateSamlServiceProvider(SamlServiceProvider provider, IdentityZone zone) throws MetadataProviderException {
        if (provider == null) {
            throw new NullPointerException();
        }
        if (!StringUtils.hasText((String)provider.getIdentityZoneId())) {
            throw new NullPointerException("You must set the SAML SP Identity Zone Id.");
        }
        if (!zone.getId().equals(provider.getIdentityZoneId())) {
            throw new IllegalArgumentException("The SAML SP Identity Zone Id does not match the curent zone.");
        }
        ExtendedMetadataDelegate added = this.getExtendedMetadataDelegate(provider);
        String metadataEntityId = ((ConfigMetadataProvider)added.getDelegate()).getEntityID();
        if (provider.getEntityId() == null) {
            provider.setEntityId(metadataEntityId);
        } else if (!metadataEntityId.equals(provider.getEntityId())) {
            throw new MetadataProviderException("Metadata entity id does not match SAML SP entity id: " + provider.getEntityId());
        }
        added.initialize();
        SPSSODescriptor spSsoDescriptor = added.getEntityDescriptor(metadataEntityId).getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        if (null != spSsoDescriptor && null != spSsoDescriptor.getNameIDFormats() && !spSsoDescriptor.getNameIDFormats().isEmpty() && !spSsoDescriptor.getNameIDFormats().stream().anyMatch(format -> this.supportedNameIDs.contains(format.getFormat()))) {
            throw new MetadataProviderException("UAA does not support any of the NameIDFormats specified in the metadata for entity: " + provider.getEntityId());
        }
        List<SamlServiceProviderHolder> serviceProviders = this.getSamlServiceProvidersForZone(zone);
    }

    public ExtendedMetadataDelegate getExtendedMetadataDelegate(SamlServiceProvider provider) throws MetadataProviderException {
        ExtendedMetadataDelegate metadata;
        switch (provider.getConfig().getType()) {
            case DATA: {
                metadata = this.configureXMLMetadata(provider);
                break;
            }
            case URL: {
                metadata = this.configureURLMetadata(provider);
                break;
            }
            default: {
                throw new MetadataProviderException("Invalid metadata type for alias[" + provider.getEntityId() + "]:" + provider.getConfig().getMetaDataLocation());
            }
        }
        return metadata;
    }

    protected ExtendedMetadataDelegate configureXMLMetadata(SamlServiceProvider provider) {
        ConfigMetadataProvider configMetadataProvider = new ConfigMetadataProvider(provider.getIdentityZoneId(), provider.getEntityId(), provider.getConfig().getMetaDataLocation());
        configMetadataProvider.setParserPool((ParserPool)this.getParserPool());
        ExtendedMetadata extendedMetadata = new ExtendedMetadata();
        extendedMetadata.setLocal(false);
        extendedMetadata.setAlias(provider.getEntityId());
        ExtendedMetadataDelegate delegate = new ExtendedMetadataDelegate((MetadataProvider)configMetadataProvider, extendedMetadata);
        delegate.setMetadataTrustCheck(provider.getConfig().isMetadataTrustCheck());
        return delegate;
    }

    protected ExtendedMetadataDelegate configureURLMetadata(SamlServiceProvider provider) throws MetadataProviderException {
        FixedHttpMetaDataProvider fixedHttpMetaDataProvider;
        SamlServiceProviderDefinition def = provider.getConfig().clone();
        ExtendedMetadata extendedMetadata = new ExtendedMetadata();
        extendedMetadata.setAlias(provider.getEntityId());
        try {
            fixedHttpMetaDataProvider = FixedHttpMetaDataProvider.buildProvider(this.dummyTimer, this.getClientParams(), this.adjustURIForPort(def.getMetaDataLocation()), new RestTemplate(UaaHttpRequestUtils.createRequestFactory(def.isSkipSslValidation())), this.contentCache);
        }
        catch (URISyntaxException e) {
            throw new MetadataProviderException("Invalid metadata URI: " + def.getMetaDataLocation(), (Exception)e);
        }
        byte[] metadata = fixedHttpMetaDataProvider.fetchMetadata();
        def.setMetaDataLocation(new String(metadata, StandardCharsets.UTF_8));
        return this.configureXMLMetadata(provider);
    }

    protected String adjustURIForPort(String uri) throws URISyntaxException {
        URI metadataURI = new URI(uri);
        if (metadataURI.getPort() < 0) {
            switch (metadataURI.getScheme()) {
                case "https": {
                    return new URIBuilder(uri).setPort(443).build().toString();
                }
                case "http": {
                    return new URIBuilder(uri).setPort(80).build().toString();
                }
            }
            return uri;
        }
        return uri;
    }

    public SamlServiceProviderProvisioning getProviderProvisioning() {
        return this.providerProvisioning;
    }

    public void setProviderProvisioning(SamlServiceProviderProvisioning providerProvisioning) {
        this.providerProvisioning = providerProvisioning;
    }

    public HttpClientParams getClientParams() {
        return this.clientParams;
    }

    public void setClientParams(HttpClientParams clientParams) {
        this.clientParams = clientParams;
    }

    public BasicParserPool getParserPool() {
        return this.parserPool;
    }

    public void setParserPool(BasicParserPool parserPool) {
        this.parserPool = parserPool;
    }

    public void setSupportedNameIDs(Set<String> supportedNameIDs) {
        this.supportedNameIDs = supportedNameIDs;
    }
}

