/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import org.cloudfoundry.identity.uaa.zone.GeneralIdentityZoneConfigurationValidator;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneConfigurationValidator;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneValidator;
import org.cloudfoundry.identity.uaa.zone.InvalidIdentityZoneConfigurationException;
import org.cloudfoundry.identity.uaa.zone.InvalidIdentityZoneDetailsException;
import org.springframework.util.StringUtils;

public class GeneralIdentityZoneValidator
implements IdentityZoneValidator {
    private final IdentityZoneConfigurationValidator configValidator;

    public GeneralIdentityZoneValidator() {
        this(new GeneralIdentityZoneConfigurationValidator());
    }

    public GeneralIdentityZoneValidator(IdentityZoneConfigurationValidator configValidator) {
        this.configValidator = configValidator;
    }

    @Override
    public IdentityZone validate(IdentityZone identityZone, IdentityZoneValidator.Mode mode) throws InvalidIdentityZoneDetailsException {
        try {
            identityZone.setConfig(this.configValidator.validate(identityZone, mode));
        }
        catch (InvalidIdentityZoneConfigurationException ex) {
            String configErrorMessage = StringUtils.hasText((String)ex.getMessage()) ? ex.getMessage() : "";
            throw new InvalidIdentityZoneDetailsException("The zone configuration is invalid. " + configErrorMessage, ex);
        }
        return identityZone;
    }
}

