/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.oauth;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.cache.UrlContentCache;
import org.cloudfoundry.identity.uaa.provider.AbstractIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.AbstractXOAuthIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.OIDCIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;
import org.springframework.web.client.RestTemplate;

public class XOAuthProviderConfigurator
implements IdentityProviderProvisioning {
    private static Log log = LogFactory.getLog(XOAuthProviderConfigurator.class);
    private final IdentityProviderProvisioning providerProvisioning;
    private final UrlContentCache contentCache;
    private final RestTemplate trustingRestTemplate;
    private final RestTemplate nonTrustingRestTemplate;

    public XOAuthProviderConfigurator(IdentityProviderProvisioning providerProvisioning, UrlContentCache contentCache, RestTemplate trustingRestTemplate, RestTemplate nonTrustingRestTemplate) {
        this.providerProvisioning = providerProvisioning;
        this.contentCache = contentCache;
        this.trustingRestTemplate = trustingRestTemplate;
        this.nonTrustingRestTemplate = nonTrustingRestTemplate;
    }

    protected OIDCIdentityProviderDefinition overlay(OIDCIdentityProviderDefinition definition) {
        if (definition.getDiscoveryUrl() == null) {
            return definition;
        }
        boolean skipSslValidation = definition.isSkipSslValidation();
        byte[] oidcJson = skipSslValidation ? this.contentCache.getUrlContent(definition.getDiscoveryUrl().toString(), this.trustingRestTemplate) : this.contentCache.getUrlContent(definition.getDiscoveryUrl().toString(), this.nonTrustingRestTemplate);
        Map oidcConfig = (Map)JsonUtils.readValue((byte[])oidcJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
        OIDCIdentityProviderDefinition overlayedDefinition = null;
        try {
            overlayedDefinition = (OIDCIdentityProviderDefinition)definition.clone();
            URL authorizationEndpoint = new URL((String)oidcConfig.get("authorization_endpoint"));
            URL userinfoEndpoint = new URL((String)oidcConfig.get("userinfo_endpoint"));
            URL tokenEndpoint = new URL((String)oidcConfig.get("token_endpoint"));
            URL tokenKeyUrl = new URL((String)oidcConfig.get("jwks_uri"));
            String issuer = (String)oidcConfig.get("issuer");
            overlayedDefinition.setAuthUrl(Optional.ofNullable(overlayedDefinition.getAuthUrl()).orElse(authorizationEndpoint));
            overlayedDefinition.setUserInfoUrl(Optional.ofNullable(overlayedDefinition.getUserInfoUrl()).orElse(userinfoEndpoint));
            overlayedDefinition.setTokenUrl(Optional.ofNullable(overlayedDefinition.getTokenUrl()).orElse(tokenEndpoint));
            overlayedDefinition.setIssuer(Optional.ofNullable(overlayedDefinition.getIssuer()).orElse(issuer));
            overlayedDefinition.setTokenKeyUrl(Optional.ofNullable(overlayedDefinition.getTokenKeyUrl()).orElse(tokenKeyUrl));
        }
        catch (CloneNotSupportedException | MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        return overlayedDefinition;
    }

    public String getCompleteAuthorizationURI(String alias, String baseURL, AbstractXOAuthIdentityProviderDefinition definition) {
        try {
            String authUrlBase = definition instanceof OIDCIdentityProviderDefinition ? this.overlay((OIDCIdentityProviderDefinition)definition).getAuthUrl().toString() : definition.getAuthUrl().toString();
            String queryAppendDelimiter = authUrlBase.contains("?") ? "&" : "?";
            ArrayList<String> query = new ArrayList<String>();
            query.add("client_id=" + definition.getRelyingPartyId());
            query.add("response_type=" + URLEncoder.encode(definition.getResponseType(), "UTF-8"));
            query.add("redirect_uri=" + URLEncoder.encode(baseURL + "/login/callback/" + alias, "UTF-8"));
            if (definition.getScopes() != null && !definition.getScopes().isEmpty()) {
                query.add("scope=" + URLEncoder.encode(String.join((CharSequence)" ", definition.getScopes()), "UTF-8"));
            }
            if (OIDCIdentityProviderDefinition.class.equals((Object)definition.getParameterizedClass())) {
                RandomValueStringGenerator nonceGenerator = new RandomValueStringGenerator(12);
                query.add("nonce=" + nonceGenerator.generate());
            }
            String queryString = String.join((CharSequence)"&", query);
            return authUrlBase + queryAppendDelimiter + queryString;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public IdentityProvider create(IdentityProvider identityProvider, String zoneId) {
        return this.providerProvisioning.create(identityProvider, zoneId);
    }

    @Override
    public IdentityProvider update(IdentityProvider identityProvider, String zoneId) {
        return this.providerProvisioning.update(identityProvider, zoneId);
    }

    @Override
    public IdentityProvider retrieve(String id, String zoneId) {
        IdentityProvider p = this.providerProvisioning.retrieve(id, zoneId);
        if (p != null && p.getType().equals("oidc1.0")) {
            p.setConfig((AbstractIdentityProviderDefinition)this.overlay((OIDCIdentityProviderDefinition)p.getConfig()));
        }
        return p;
    }

    @Override
    public List<IdentityProvider> retrieveActive(String zoneId) {
        return this.retrieveAll(true, zoneId);
    }

    public IdentityProvider retrieveByIssuer(String issuer, String zoneId) throws IncorrectResultSizeDataAccessException {
        List providers = this.retrieveAll(true, zoneId).stream().filter(p -> "oidc1.0".equals(p.getType()) && issuer.equals(((OIDCIdentityProviderDefinition)p.getConfig()).getIssuer())).collect(Collectors.toList());
        if (providers.isEmpty()) {
            throw new IncorrectResultSizeDataAccessException(String.format("Active provider with issuer[%s] not found", issuer), 1);
        }
        if (providers.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(String.format("Duplicate providers with issuer[%s] not found", issuer), 1);
        }
        return (IdentityProvider)providers.get(0);
    }

    @Override
    public List<IdentityProvider> retrieveAll(boolean activeOnly, String zoneId) {
        List<String> types = Arrays.asList("oauth2.0", "oidc1.0");
        List<IdentityProvider> providers = this.providerProvisioning.retrieveAll(activeOnly, zoneId);
        ArrayList<IdentityProvider> overlayedProviders = new ArrayList<IdentityProvider>();
        Optional.ofNullable(providers).orElse(Collections.emptyList()).stream().filter(p -> types.contains(p.getType())).forEach(p -> {
            if (p.getType().equals("oidc1.0")) {
                try {
                    OIDCIdentityProviderDefinition overlayedDefinition = this.overlay((OIDCIdentityProviderDefinition)p.getConfig());
                    p.setConfig((AbstractIdentityProviderDefinition)overlayedDefinition);
                }
                catch (Exception e) {
                    log.error((Object)"Identity provider excluded from login page due to a problem.", (Throwable)e);
                    return;
                }
            }
            overlayedProviders.add((IdentityProvider)p);
        });
        return overlayedProviders;
    }

    @Override
    public IdentityProvider retrieveByOrigin(String origin, String zoneId) {
        IdentityProvider p = this.providerProvisioning.retrieveByOrigin(origin, zoneId);
        if (p != null && p.getType().equals("oidc1.0")) {
            p.setConfig((AbstractIdentityProviderDefinition)this.overlay((OIDCIdentityProviderDefinition)p.getConfig()));
        }
        return p;
    }
}

