/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.account;

import java.util.List;
import org.cloudfoundry.identity.uaa.account.UaaUserDetails;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;
import org.springframework.security.openid.OpenIDAttribute;
import org.springframework.security.openid.OpenIDAuthenticationToken;
import org.springframework.util.StringUtils;

public class OpenIdUserDetailsService
implements AuthenticationUserDetailsService<OpenIDAuthenticationToken> {
    private RandomValueStringGenerator generator = new RandomValueStringGenerator();

    public UserDetails loadUserDetails(OpenIDAuthenticationToken token) {
        String[] names;
        String email = null;
        String firstName = null;
        String lastName = null;
        String fullName = null;
        List attributes = token.getAttributes();
        for (OpenIDAttribute attribute : attributes) {
            if (attribute.getName().equals("email")) {
                email = (String)attribute.getValues().get(0);
            }
            if (attribute.getName().equals("firstname")) {
                firstName = (String)attribute.getValues().get(0);
            }
            if (attribute.getName().equals("lastname")) {
                lastName = (String)attribute.getValues().get(0);
            }
            if (!attribute.getName().equals("fullname")) continue;
            fullName = (String)attribute.getValues().get(0);
        }
        if (firstName == null && StringUtils.hasText(fullName)) {
            names = fullName.split(" ");
            firstName = names[0];
        }
        if (lastName == null && StringUtils.hasText(fullName)) {
            names = fullName.split(" ");
            String string = lastName = names.length > 1 ? names[1] : "User";
        }
        if (firstName == null && StringUtils.hasText(email)) {
            names = email.split("@");
            firstName = names[0];
        }
        if (lastName == null && StringUtils.hasText(email)) {
            names = email.split("@");
            lastName = names.length > 1 ? names[1] : "User";
        }
        UaaUser user = new UaaUser(email, this.generator.generate(), email, firstName, lastName);
        return new UaaUserDetails(user);
    }
}

