/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.mfa;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.mfa.MfaChecker;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.web.filter.GenericFilterBean;

public class MfaUiRequiredFilter
extends GenericFilterBean {
    private static Log logger = LogFactory.getLog(MfaUiRequiredFilter.class);
    private final AntPathRequestMatcher inProgressMatcher;
    private final AntPathRequestMatcher completedMatcher;
    private final AntPathRequestMatcher logoutMatcher;
    private final String redirect;
    private final RequestCache cache;
    private final MfaChecker checker;

    public MfaUiRequiredFilter(String urlFilter, String redirect, RequestCache cache, String mfaCompleteUrl, AntPathRequestMatcher logoutMatcher, MfaChecker checker) {
        this.inProgressMatcher = new AntPathRequestMatcher(urlFilter);
        this.redirect = redirect;
        this.cache = cache;
        this.completedMatcher = new AntPathRequestMatcher(mfaCompleteUrl);
        this.checker = checker;
        this.logoutMatcher = logoutMatcher;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        switch (this.getNextStep(request)) {
            case INVALID_AUTH: {
                logger.debug((Object)("Unrecognized authentication object:" + this.getAuthenticationLogInfo()));
                response.sendError(401, "Invalid authentication object for UI operations.");
                break;
            }
            case NOT_AUTHENTICATED: 
            case MFA_IN_PROGRESS: 
            case MFA_NOT_REQUIRED: 
            case MFA_OK: {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                break;
            }
            case MFA_REQUIRED: {
                logger.debug((Object)("Request requires MFA, redirecting to MFA flow for " + this.getAuthenticationLogInfo()));
                this.cache.saveRequest(request, response);
                this.sendRedirect(this.redirect, request, response);
                break;
            }
            case MFA_COMPLETED: {
                logger.debug((Object)("MFA has been completed for " + this.getAuthenticationLogInfo()));
                SavedRequest savedRequest = this.cache.getRequest(request, response);
                if (savedRequest != null) {
                    logger.debug((Object)("Redirecting request to " + savedRequest.getRedirectUrl()));
                    this.sendRedirect(savedRequest.getRedirectUrl(), request, response);
                    break;
                }
                logger.debug((Object)"Redirecting request to /");
                this.sendRedirect("/", request, response);
            }
        }
    }

    protected String getAuthenticationLogInfo() {
        Authentication a = SecurityContextHolder.getContext().getAuthentication();
        if (a == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        if (a instanceof UaaAuthentication) {
            UaaPrincipal principal = ((UaaAuthentication)a).getPrincipal();
            result.append("Username:").append(principal.getName()).append(" User-ID:").append(principal.getId());
        } else {
            result.append("Unknown Auth=").append(a).append(" Principal=" + a.getPrincipal());
        }
        return result.toString();
    }

    protected MfaNextStep getNextStep(HttpServletRequest request) {
        Authentication a = SecurityContextHolder.getContext().getAuthentication();
        if (a == null || a instanceof AnonymousAuthenticationToken) {
            return MfaNextStep.NOT_AUTHENTICATED;
        }
        if (!(a instanceof UaaAuthentication)) {
            return MfaNextStep.INVALID_AUTH;
        }
        UaaAuthentication uaaAuth = (UaaAuthentication)a;
        if (!this.mfaRequired(uaaAuth.getPrincipal().getOrigin()) || this.logoutInProgress(request)) {
            return MfaNextStep.MFA_NOT_REQUIRED;
        }
        if (this.completedMatcher.matches(request) && uaaAuth.getAuthenticationMethods().contains("mfa")) {
            return MfaNextStep.MFA_COMPLETED;
        }
        if (this.inProgressMatcher.matches(request) && !uaaAuth.getAuthenticationMethods().contains("mfa")) {
            return MfaNextStep.MFA_IN_PROGRESS;
        }
        if (!this.inProgressMatcher.matches(request) && !uaaAuth.getAuthenticationMethods().contains("mfa")) {
            return MfaNextStep.MFA_REQUIRED;
        }
        if (uaaAuth.getAuthenticationMethods().contains("mfa")) {
            return MfaNextStep.MFA_OK;
        }
        return MfaNextStep.INVALID_AUTH;
    }

    protected void sendRedirect(String redirectUrl, HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuilder url = new StringBuilder(redirectUrl.startsWith("/") ? request.getContextPath() : "");
        url.append(redirectUrl);
        response.sendRedirect(url.toString());
    }

    protected boolean mfaRequired(String origin) {
        return this.checker.isMfaEnabled(IdentityZoneHolder.get(), origin);
    }

    private boolean logoutInProgress(HttpServletRequest request) {
        return this.logoutMatcher.matches(request);
    }

    public static enum MfaNextStep {
        NOT_AUTHENTICATED,
        MFA_IN_PROGRESS,
        MFA_REQUIRED,
        MFA_OK,
        MFA_NOT_REQUIRED,
        MFA_COMPLETED,
        INVALID_AUTH;

    }
}

