/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.audit.event;

import org.apache.commons.logging.Log;
import org.cloudfoundry.identity.uaa.audit.event.AbstractUaaEvent;
import org.cloudfoundry.identity.uaa.audit.event.EntityDeletedEvent;
import org.cloudfoundry.identity.uaa.mfa.MfaProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.context.ApplicationListener;
import org.springframework.security.oauth2.provider.ClientDetails;

public interface SystemDeletable
extends ApplicationListener<AbstractUaaEvent> {
    default public void onApplicationEvent(EntityDeletedEvent<?> event) {
        if (event == null || event.getDeleted() == null) {
            return;
        }
        if (event.getDeleted() instanceof IdentityZone) {
            String zoneId = ((IdentityZone)event.getDeleted()).getId();
            this.getLogger().debug((Object)String.format("Received zone deletion event for id:%s", zoneId));
            if (this.isUaaZone(zoneId)) {
                this.getLogger().debug((Object)("Attempt to delete default zone ignored:" + event.getDeleted()));
                return;
            }
            this.deleteByIdentityZone(zoneId);
        } else if (event.getDeleted() instanceof IdentityProvider) {
            String zoneId = ((IdentityProvider)event.getDeleted()).getIdentityZoneId();
            String origin = ((IdentityProvider)event.getDeleted()).getOriginKey();
            this.getLogger().debug((Object)String.format("Received provider deletion event for zone_id:%s and origin:%s", zoneId, origin));
            if ("uaa".equals(origin)) {
                this.getLogger().debug((Object)("Attempt to delete default UAA provider ignored:" + event.getDeleted()));
                return;
            }
            this.deleteByOrigin(origin, zoneId);
        } else if (event.getDeleted() instanceof ClientDetails) {
            String clientId = ((ClientDetails)event.getDeleted()).getClientId();
            String zoneId = IdentityZoneHolder.get().getId();
            this.getLogger().debug((Object)String.format("Received client deletion event for zone_id:%s and client:%s", zoneId, clientId));
            this.deleteByClient(clientId, zoneId);
        } else if (event.getDeleted() instanceof UaaUser) {
            String userId = ((UaaUser)event.getDeleted()).getId();
            String zoneId = ((UaaUser)event.getDeleted()).getZoneId();
            this.getLogger().debug((Object)String.format("Received UAA user deletion event for zone_id:%s and user:%s", zoneId, userId));
            this.deleteByUser(userId, zoneId);
        } else if (event.getDeleted() instanceof ScimUser) {
            String userId = ((ScimUser)event.getDeleted()).getId();
            String zoneId = ((ScimUser)event.getDeleted()).getZoneId();
            this.getLogger().debug((Object)String.format("Received SCIM user deletion event for zone_id:%s and user:%s", zoneId, userId));
            this.deleteByUser(userId, zoneId);
        } else if (event.getDeleted() instanceof MfaProvider) {
            String providerId = ((MfaProvider)event.getDeleted()).getId();
            String zoneId = IdentityZoneHolder.get().getId();
            this.deleteByMfaProvider(providerId, zoneId);
        } else {
            this.getLogger().debug((Object)("Unsupported deleted event for deletion of object:" + event.getDeleted()));
        }
    }

    default public void onApplicationEvent(AbstractUaaEvent event) {
        if (event instanceof EntityDeletedEvent) {
            this.onApplicationEvent((EntityDeletedEvent)event);
        }
    }

    default public boolean isUaaZone(String zoneId) {
        return IdentityZone.getUaa().getId().equals(zoneId);
    }

    default public int deleteByIdentityZone(String zoneId) {
        return 0;
    }

    default public int deleteByOrigin(String origin, String zoneId) {
        return 0;
    }

    default public int deleteByClient(String clientId, String zoneId) {
        return 0;
    }

    default public int deleteByUser(String userId, String zoneId) {
        return 0;
    }

    default public int deleteByMfaProvider(String id, String zoneId) {
        return 0;
    }

    public Log getLogger();
}

