/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.jdbc.pool.FairBlockingQueue;
import org.cloudfoundry.identity.uaa.util.RuntimeEnvironment;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.ReflectionUtils;

@ManagedResource(objectName="cloudfoundry.identity:name=BcryptConcurrency", description="Bcrypt Concurrency")
public class LowConcurrencyPasswordEncoder
implements PasswordEncoder {
    private static Log logger = LogFactory.getLog(LowConcurrencyPasswordEncoder.class);
    private final PasswordEncoder delegate;
    private final int max;
    private final BlockingQueue<BcrypWaitingResource> exchange;
    private final long timeoutMs;
    private final AtomicLong counter = new AtomicLong(0L);

    protected LowConcurrencyPasswordEncoder(PasswordEncoder delegate, long timeoutMs, boolean enabled, RuntimeEnvironment environment) {
        this.delegate = delegate;
        this.timeoutMs = timeoutMs;
        int processors = environment.availableProcessors();
        if (enabled) {
            switch (processors) {
                case 1: {
                    this.max = 1;
                    break;
                }
                case 2: {
                    this.max = 1;
                    break;
                }
                case 3: {
                    this.max = 2;
                    break;
                }
                case 4: {
                    this.max = 3;
                    break;
                }
                default: {
                    this.max = processors - 2;
                }
            }
            this.exchange = new FairBlockingQueue();
            for (int i = 0; i < this.max; ++i) {
                this.exchange.offer(new BcrypWaitingResource(this.exchange, "LowConcurrency Waiter Nr:" + this.counter.incrementAndGet()));
            }
        } else {
            this.exchange = null;
            this.max = processors;
        }
    }

    @ManagedMetric(category="scalability", displayName="Max Bcrypt Threads")
    public int getMax() {
        return this.max;
    }

    @ManagedMetric(category="scalability", displayName="Current Bcrypt Executions")
    public int getCurrent() {
        if (this.exchange != null) {
            return this.max - this.exchange.size();
        }
        return -1;
    }

    @ManagedMetric(category="scalability", displayName="Bcrypt Threads Waiting", description="Approximate number of threads waiting to perform a bcrypt operation.")
    public int getWaiters() {
        if (this.exchange != null) {
            try {
                Field waiters = ReflectionUtils.findField(this.exchange.getClass(), (String)"waiters");
                ReflectionUtils.makeAccessible((Field)waiters);
                Object actualWaiters = waiters.get(this.exchange);
                Method size = ReflectionUtils.findMethod(actualWaiters.getClass(), (String)"size");
                return (Integer)ReflectionUtils.invokeMethod((Method)size, (Object)actualWaiters);
            }
            catch (Exception e) {
                logger.debug((Object)"Unable to read waiter size", (Throwable)e);
                return -1;
            }
        }
        return 0;
    }

    public String encode(CharSequence rawPassword) throws AuthenticationException {
        try (BcrypWaitingResource waiting = this.waitIfWeNeedTo();){
            logger.debug((Object)("Bcrypt encode proceed with " + waiting.getName()));
            String string = this.delegate.encode(rawPassword);
            return string;
        }
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) throws AuthenticationException {
        try (BcrypWaitingResource waiting = this.waitIfWeNeedTo();){
            logger.debug((Object)("Bcrypt matches proceed with " + waiting.getName()));
            boolean bl = this.delegate.matches(rawPassword, encodedPassword);
            return bl;
        }
    }

    public BcrypWaitingResource waitIfWeNeedTo() throws AuthenticationServiceException {
        long request = this.counter.incrementAndGet();
        try {
            if (this.exchange != null) {
                BcrypWaitingResource resource = this.exchange.poll(this.timeoutMs, TimeUnit.MILLISECONDS);
                if (resource == null) {
                    throw new AuthenticationServiceException("System resources busy. Try again.");
                }
                return resource;
            }
            return new BcrypWaitingResource(null, "Request nr:" + request){

                @Override
                public void close() {
                }
            };
        }
        catch (InterruptedException e) {
            throw new AuthenticationServiceException("Bcrypt thread was interrupted, unable to validate.", (Throwable)e);
        }
    }

    private static class BcrypWaitingResource
    implements AutoCloseable {
        private final BlockingQueue<BcrypWaitingResource> exchange;
        private final String name;

        private BcrypWaitingResource(BlockingQueue<BcrypWaitingResource> exchange, String name) {
            this.exchange = exchange;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public void close() {
            this.exchange.offer(this);
        }
    }
}

